/**
 * 
 */
package org.isuper.common.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Super Wang
 *
 */
public class CookieUtils {

	/**
	 * Read a value stored in cookies with specified key
	 * 
	 * @param key
	 * 			The key for the stored value in cookies
	 * @param request
	 * 			The HttpServletRequest to read cookies from
	 * @return
	 * 			The value of the specified key in cookies
	 */
	public static String getCookieValue(String key, HttpServletRequest request) {
		Cookie[] cookies = request.getCookies();
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				if (cookie != null && cookie.getName().equals(key)) {
					return cookie.getValue();
				}
			}
		}
		return null;
	}

	/**
	 * Save a value in cookies with specified key and expiration time, if the value is null, it will be removed from cookies
	 * 
	 * @param key
	 * 			The key for the stored value in cookies
	 * @param value
	 * 			The value to store in cookies
	 * @param expiration
	 * 			The expiration time
	 * @param request
	 * 			HttpServletRequest
	 * @param response
	 * 			HttpServletResponse
	 */
	public static void putCookie(String key, String value, int expiration, HttpServletRequest request, HttpServletResponse response) {
		if (value == null) {
			removeCookie(key, request, response);
		} else {
			Cookie c = new Cookie(key, value);
			c.setMaxAge(expiration);
			String path = request.getContextPath();
			if (Preconditions.isEmptyString(path)) {
				path = "/";
			}
			c.setPath(path);
			response.addCookie(c);
		}
	}

	/**
	 * Remove a stored value from cookies with specified key
	 * 
	 * @param key
	 * 			The key to remove from cookies
	 * @param request
	 * 			HttpServletRequest
	 * @param response
	 * 			HttpServletResponse
	 */
	public static void removeCookie(String key, HttpServletRequest request, HttpServletResponse response) {
		Cookie c = new Cookie(key, "");
		c.setMaxAge(0);
		String path = request.getContextPath();
		if (Preconditions.isEmptyString(path)) {
			path = "/";
		}
		c.setPath(path);
		response.addCookie(c);
	}

}
