/**
 * 
 */
package org.isuper.common.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Super Wang
 *
 */
@XmlRootElement(name="feed")
@XmlAccessorType(XmlAccessType.FIELD)
public class FeedWithElapsed<T> implements Feed<T>, Elapsed, Serializable {
	
	private static final long serialVersionUID = 4301670710760794791L;
	
	@XmlElement
	private int curPage;
	@XmlElement
	private int perPage;
	@XmlElement
	private int total;
	@XmlElement
	private Collection<T> data;
	@XmlElement
	private long elapsedTime;
	@XmlElement
	private TimeUnit timeUnit;
	
	@Override
	public int getCurPage() {
		return this.curPage;
	}
	public void setCurPage(int curPage) {
		this.curPage = curPage;
	}
	@Override
	public int getPerPage() {
		return this.perPage;
	}
	public void setPerPage(int perPage) {
		this.perPage = perPage;
	}
	@Override
	public int getTotal() {
		return this.total;
	}
	public void setTotal(int total) {
		this.total = total;
	}
	@Override
	public Collection<T> getData() {
		return this.data;
	}
	public void setData(Collection<T> data) {
		this.data = data;
		if (this.data.size() < this.perPage) {
			this.perPage = this.data.size();
		}
	}
	public void setElapsedTime(TimeUnit timeUnit, long elapsedTime) {
		this.timeUnit = timeUnit;
		this.elapsedTime = elapsedTime;
	}
	@Override
	public long getElapsedTime() {
		return this.elapsedTime;
	}
	@Override
	public TimeUnit getTimeUnit() {
		return this.timeUnit;
	}

}
