/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.common.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.isuper.common.utils.Preconditions;

public final class Secure {
    private static final String CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final int CHARACTERS_LENGTH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".length();
    private static final int DEFAULT_PASSWORD_LENGTH = 16;
    private static final int ITERATION_COUNT = 8192;
    private static final int KEY_SIZE = 160;
    private static final String UTF_8_ENCODING = "UTF-8";

    public static String generate() {
        return Secure.generate(16);
    }

    public static String generate(int length) {
        int len = length;
        if (len < 0) {
            len = 16;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            double index = Math.random() * (double)CHARACTERS_LENGTH;
            builder.append(CHARACTERS.charAt((int)index));
        }
        return builder.toString();
    }

    public static byte[] hashPassword(char[] password, byte[] salt) throws GeneralSecurityException {
        return Secure.hashPassword(password, salt, 8192, 160);
    }

    public static byte[] hashPassword(char[] password, byte[] salt, int iterationCount, int keySize) throws GeneralSecurityException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterationCount, keySize);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        return factory.generateSecret(spec).getEncoded();
    }

    public static boolean matches(byte[] passwordHash, char[] password, byte[] salt) throws GeneralSecurityException {
        return Secure.matches(passwordHash, password, salt, 8192, 160);
    }

    public static boolean matches(byte[] passwordHash, char[] password, byte[] salt, int iterationCount, int keySize) throws GeneralSecurityException {
        return Arrays.equals(passwordHash, Secure.hashPassword(password, salt, iterationCount, keySize));
    }

    public static byte[] nextSalt() {
        byte[] salt = new byte[16];
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.nextBytes(salt);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return salt;
    }

    public static String state() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    public static String base64Encode(String source) {
        if (Preconditions.isEmptyString(source)) {
            return null;
        }
        try {
            return Base64.encodeBase64URLSafeString((byte[])source.getBytes(UTF_8_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String base64Decode(String source) {
        if (Preconditions.isEmptyString(source)) {
            return null;
        }
        try {
            return new String(Base64.decodeBase64((String)source), UTF_8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5(String source) {
        if (Preconditions.isEmptyString(source)) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder result = new StringBuilder();
            try {
                for (byte b : md.digest(source.getBytes(UTF_8_ENCODING))) {
                    result.append(Integer.toHexString((b & 0xF0) >>> 4));
                    result.append(Integer.toHexString(b & 0xF));
                }
            }
            catch (UnsupportedEncodingException e) {
                for (byte b : md.digest(source.getBytes())) {
                    result.append(Integer.toHexString((b & 0xF0) >>> 4));
                    result.append(Integer.toHexString(b & 0xF));
                }
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

