/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.common.rest;

import java.util.Collection;

/**
 * @author Super Wayne
 *
 */
public interface RestFeed<T> extends RestResult<Collection<T>> {
	
	/**
	 * @return
	 * 			The current page index, start from 1 not zero
	 */
	public int getCurPage();
	
	/**
	 * @return
	 * 			The items count per page
	 */
	public int getPerPage();
	
	/**
	 * @return
	 * 			The total count of all items
	 */
	public int getTotal();
	
}
