/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.common.rest;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Super Wayne
 *
 */
@XmlRootElement(name="result")
@XmlAccessorType(XmlAccessType.FIELD)
public class SimpleRestResult<T> implements RestResult<T>, Serializable {
	
	private static final long serialVersionUID = 4301670710760794791L;
	
	@XmlElement
	private T data;
	@XmlElement
	private long lastUpdatedTimeMs;
	
	/* (non-Javadoc)
	 * @see org.isuper.common.rest.RestResult#getData()
	 */
	@Override
	public T getData() {
		return this.data;
	}
	/**
	 * @param data
	 * 				The data to set
	 */
	public void setData(T data) {
		this.data = data;
	}
	/* (non-Javadoc)
	 * @see eye.api.core.models.RestResult#getLastUpdatedTimeMs()
	 */
	@Override
	public long getLastUpdatedTimeMs() {
		return this.lastUpdatedTimeMs;
	}
	/**
	 * @param lastUpdatedTimeMs
	 * 				The last updated time stamp in millisecond to set
	 */
	public void setLastUpdatedTimeMs(long lastUpdatedTimeMs) {
		this.lastUpdatedTimeMs = lastUpdatedTimeMs;
	}

}
