/**
 * 
 */
package org.isuper.geometry;

import java.io.IOException;
import java.io.Serializable;

import org.isuper.geometry.utils.GeometryUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Super Wang
 *
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapBounds implements Serializable {

	private static final long serialVersionUID = -7626569959610792516L;
	
	public final Coordinate ne;
	public final Coordinate sw;
	
	@JsonCreator
	public MapBounds(@JsonProperty("ne") Coordinate ne, @JsonProperty("sw") Coordinate sw) {
		if (ne == null || sw == null) {
			throw new IllegalArgumentException("The coordinates cannot be null!");
		}
		this.ne = ne;
		this.sw = sw;
	}
	
	public static MapBounds valueOf(String json) {
		try {
			return GeometryUtils.getObjectMapper().readValue(json, MapBounds.class);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static MapBounds parseFromRawString(String rawBounds) {
		String[] boundsArray = rawBounds.split(":");
		if (boundsArray.length != 2) {
			throw new IllegalArgumentException(String.format("Invalid region %s.", rawBounds));
		}
		String[] ne = boundsArray[0].split(",");
		if (ne.length != 2) {
			throw new IllegalArgumentException(String.format("Invalid north east %s.", boundsArray[0]));
		}
		String[] sw = boundsArray[1].split(",");
		if (sw.length != 2) {
			throw new IllegalArgumentException(String.format("Invalid south west %s.", boundsArray[1]));
		}
		return new MapBounds(new Coordinate(Float.parseFloat(ne[0]), Float.parseFloat(ne[1])), new Coordinate(Float.parseFloat(sw[0]), Float.parseFloat(sw[1])));
	}
	
	public String toJSON() {
		try {
			return GeometryUtils.getObjectMapper().writeValueAsString(this);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "{}";
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toJSON();
	}
	
}
