/**
 * Copyright 2014-2016 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.geometry;

/**
 * @author Super Wayne
 *
 */
public class WeightedLocation {
	
	private final Coordinate location;
	private float weight;
	
	/**
	 * @param location
	 * @param weight
	 */
	public WeightedLocation(Coordinate location, float weight) {
		if (location == null) {
			throw new IllegalArgumentException("Location should be provided");
		}
		this.location = location;
		if (weight <= 0) {
			throw new IllegalArgumentException("Weight should be greater than 0");
		}
		this.weight = weight;
	}

	/**
	 * @return the location
	 */
	public Coordinate getLocation() {
		return this.location;
	}

	/**
	 * @return the weight
	 */
	public float getWeight() {
		return this.weight;
	}

}
