/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.geometry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.isuper.geometry.Coordinate;
import org.isuper.geometry.utils.GeometryUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GeometryPoint
implements Serializable {
    private static final long serialVersionUID = -8542832583141128351L;
    public final String type;
    public final double[] coordinates;

    public GeometryPoint(@JsonProperty(value="type") String type, @JsonProperty(value="coordinates") double[] coordinates) {
        this.type = type;
        if (!GeometryUtils.isValidCoordinate(coordinates[1], coordinates[0])) {
            throw new IllegalArgumentException(String.format("Invalid coordinates (lat:%f, lng:%f)", coordinates[1], coordinates[0]));
        }
        this.coordinates = coordinates;
    }

    @JsonIgnore
    public Coordinate toCoordinate() {
        return new Coordinate(this.coordinates[1], this.coordinates[0]);
    }

    @JsonIgnore
    public static GeometryPoint fromCoordinate(Coordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        return new GeometryPoint("POINT", new double[]{coordinate.getLng(), coordinate.getLat()});
    }

    @JsonIgnore
    public String toGeometryText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.toUpperCase());
        builder.append("(");
        builder.append(String.format("%f", this.coordinates[1])).append(" ").append(String.format("%f", this.coordinates[0]));
        builder.append(")");
        return builder.toString();
    }

    public static GeometryPoint fromGeometryText(String geometry) {
        GeometryPoint point = null;
        if (geometry == null) {
            return point;
        }
        StringTokenizer tokenizer = new StringTokenizer(geometry, "(,)", true);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (!"POINT".equals(token.toUpperCase())) {
                return null;
            }
            token = tokenizer.nextToken();
            double[] coordinates = GeometryPoint.parsePoint(tokenizer, token);
            if (coordinates == null) continue;
            point = new GeometryPoint("POINT", coordinates);
            break;
        }
        return point;
    }

    private static double[] parsePoint(StringTokenizer tokenizer, String token) {
        double[] point = null;
        if (!"(".equals(token)) {
            return point;
        }
        token = tokenizer.nextToken();
        while (!")".equals(token)) {
            String[] tmp = token.split(" ");
            if (tmp.length == 2) {
                point = new double[]{Double.parseDouble(tmp[1]), Double.parseDouble(tmp[0])};
            }
            token = tokenizer.nextToken();
        }
        return point;
    }
}

