/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.geometry.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.isuper.geometry.Coordinate;

public class GeometryUtils {
    public static final int LNG_MAX = 179999999;
    public static final int LNG_MIN = -180000000;
    public static final int LAT_MAX = 89999999;
    public static final int LAT_MIN = -90000000;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(JSON_FACTORY);

    public static JsonFactory getJsonFactory() {
        return JSON_FACTORY;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static final boolean latInRange(double lat) {
        return lat >= -90.0 && lat <= 90.0;
    }

    public static final boolean lngInRange(double lng) {
        return lng >= -180.0 && lng <= 180.0;
    }

    public static final boolean isValidCoordinate(double lat, double lng) {
        return GeometryUtils.latInRange(lat) && GeometryUtils.lngInRange(lng);
    }

    public static Coordinate wgs2gcj(Coordinate wgs) {
        double wgsLng;
        double wgsLat = wgs.getLat();
        if (GeometryUtils.isOutOfChina(wgsLat, wgsLng = wgs.getLng())) {
            return new Coordinate(wgsLat, wgsLng);
        }
        Coordinate d = GeometryUtils.delta(wgsLat, wgsLng);
        return new Coordinate(wgsLat + d.getLat(), wgsLng + d.getLng());
    }

    public static Coordinate gcj2wgs(Coordinate gcj) {
        double gcjLng;
        double gcjLat = gcj.getLat();
        if (GeometryUtils.isOutOfChina(gcjLat, gcjLng = gcj.getLng())) {
            return new Coordinate(gcjLat, gcjLng);
        }
        Coordinate d = GeometryUtils.delta(gcjLat, gcjLng);
        return new Coordinate(gcjLat - d.getLat(), gcjLng - d.getLng());
    }

    private static boolean isOutOfChina(double lat, double lng) {
        return lat < 25.40195 && lng < 125.502319 && lat > 21.675348 && lng > 119.827835 || lng < 72.004 || lng > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    private static Coordinate delta(double lat, double lng) {
        double a = 6378245.0;
        double ee = 0.006693421622965943;
        double dLat = GeometryUtils.transformLat(lng - 105.0, lat - 35.0);
        double dLng = GeometryUtils.transformLng(lng - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * Math.PI);
        dLng = dLng * 180.0 / (a / sqrtMagic * Math.cos(radLat) * Math.PI);
        return new Coordinate(dLat, dLng);
    }

    private static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLng(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static Coordinate gcj2wgsAccurate(Coordinate gcj) {
        double gcjLat = gcj.getLat();
        double gcjLng = gcj.getLng();
        double initDelta = 0.01;
        double threshold = 1.0E-6;
        double dLat = initDelta;
        double dLng = initDelta;
        double mLat = gcjLat - dLat;
        double mLng = gcjLng - dLng;
        double pLat = gcjLat + dLat;
        double pLng = gcjLng + dLng;
        Coordinate wgs = new Coordinate(mLat, mLng);
        for (int i = 0; i < 30; ++i) {
            double wgsLat = (mLat + pLat) / 2.0;
            double wgsLng = (mLng + pLng) / 2.0;
            wgs = new Coordinate(wgsLat, wgsLng);
            Coordinate tmp = GeometryUtils.wgs2gcj(wgs);
            dLat = tmp.getLat() - gcjLat;
            dLng = tmp.getLng() - gcjLng;
            if (Math.abs(dLat) < threshold && Math.abs(dLng) < threshold) {
                return wgs;
            }
            if (dLat > 0.0) {
                pLat = wgsLat;
            } else {
                mLat = wgsLat;
            }
            if (dLng > 0.0) {
                pLng = wgsLng;
                continue;
            }
            mLng = wgsLng;
        }
        return wgs;
    }
}

