/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import org.isuper.geometry.utils.GeometryUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Coordinate
implements Serializable {
    private static final long serialVersionUID = 447283454620410061L;
    private final double lat;
    private final double lng;

    @JsonCreator
    public Coordinate(@JsonProperty(value="lat") double lat, @JsonProperty(value="lng") double lng) {
        if (!GeometryUtils.isValidCoordinate(lat, lng)) {
            throw new IllegalArgumentException(String.format("Invalid coordinate: { lat: %f, lng: %f }", lat, lng));
        }
        this.lat = lat;
        this.lng = lng;
    }

    public static Coordinate valueOf(String json) {
        try {
            return (Coordinate)GeometryUtils.getObjectMapper().readValue(json, Coordinate.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJSON() {
        try {
            return GeometryUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    @JsonIgnore
    public int getLatE6() {
        return (int)Math.floor(this.lat * 1000000.0);
    }

    @JsonIgnore
    public int getLngE6() {
        return (int)Math.floor(this.lng * 1000000.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lng);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        return Double.doubleToLongBits(this.lng) == Double.doubleToLongBits(other.lng);
    }
}

