/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.isuper.geometry.Coordinate;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WeightedLocation {
    private final Coordinate location;
    private float weight;

    @JsonCreator
    public WeightedLocation(@JsonProperty(value="location") Coordinate location, @JsonProperty(value="weight") float weight) throws IllegalArgumentException {
        if (location == null) {
            throw new IllegalArgumentException("Location should be provided");
        }
        this.location = location;
        if (weight <= 0.0f) {
            throw new IllegalArgumentException("Weight should be greater than 0");
        }
        this.weight = weight;
    }

    public Coordinate getLocation() {
        return this.location;
    }

    public float getWeight() {
        return this.weight;
    }
}

