/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.social.web.utils;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.common.web.utils.CookieUtils;
import org.isuper.common.web.utils.ServletUtils;
import org.isuper.oauth.core.OAuthCredential;
import org.isuper.social.core.BaseSocialAccount;
import org.isuper.social.core.UserAccount;

public final class SocialUtils {
    public static final String PATH_VERIFY = "/social/verify";
    public static final String PATH_ASSOCIATE = "/social/associate";
    private static final Logger DEFAULT_LOGGER = LogManager.getLogger((String)SocialUtils.class.getName());
    private static int DEFAULT_COOKIE_EXPIRES_IN_SEC_ID_TOKEN = (int)TimeUnit.HOURS.toSeconds(1L);
    private static int DEFAULT_COOKIE_EXPIRES_IN_SEC_SOCIAL_LAST_URL = (int)TimeUnit.DAYS.toSeconds(30L);

    public static final String loadIdToken(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        Object sessionIdToken = session.getAttribute(prefix + ".id_token");
        if (sessionIdToken != null && !Preconditions.isEmptyString((String)sessionIdToken.toString())) {
            String idToken = sessionIdToken.toString();
            DEFAULT_LOGGER.debug(String.format("Found ID token %s in session %s for user %s", idToken, session.getId(), req.getRemoteAddr()));
            return idToken;
        }
        String idToken = req.getHeader(prefix + ".id_token");
        if (!Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.debug(String.format("Found ID token %s in request header for user %s", idToken, req.getRemoteAddr()));
            return idToken;
        }
        idToken = req.getParameter(prefix + ".id_token");
        if (!Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.debug(String.format("Found ID token %s in request body for user %s", idToken, req.getRemoteAddr()));
            return idToken;
        }
        idToken = CookieUtils.getCookieValue((String)(prefix + ".id_token"), (HttpServletRequest)req);
        if (!Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.debug(String.format("Found ID token %s in cookies for user %s", idToken, req.getRemoteAddr()));
            return idToken;
        }
        return null;
    }

    public static final void saveIdToken(String prefix, String idToken, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        DEFAULT_LOGGER.debug(String.format("Saving ID token %s in session %s and cookies for user %s", idToken, session.getId(), req.getRemoteAddr()));
        if (Preconditions.isEmptyString((String)idToken)) {
            session.removeAttribute(prefix + ".id_token");
            CookieUtils.removeCookie((String)(prefix + ".id_token"), (HttpServletRequest)req, (HttpServletResponse)resp);
        }
        session.setAttribute(prefix + ".id_token", (Object)idToken);
        CookieUtils.putCookie((String)(prefix + ".id_token"), (String)idToken, (int)DEFAULT_COOKIE_EXPIRES_IN_SEC_ID_TOKEN, (HttpServletRequest)req, (HttpServletResponse)resp);
    }

    public static final void removeIdToken(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        SocialUtils.saveIdToken(prefix, null, req, resp);
    }

    public static final String loadRefreshToken(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        Object sessionRefreshToken = session.getAttribute(prefix + ".credential.refresh_token");
        if (sessionRefreshToken != null && !Preconditions.isEmptyString((String)sessionRefreshToken.toString())) {
            String refreshToken = sessionRefreshToken.toString();
            DEFAULT_LOGGER.debug(String.format("Found refresh token %s in session %s for user %s", refreshToken, session.getId(), req.getRemoteAddr()));
            return refreshToken;
        }
        String refreshToken = req.getHeader(prefix + ".credential.refresh_token");
        if (!Preconditions.isEmptyString((String)refreshToken)) {
            DEFAULT_LOGGER.debug(String.format("Found refresh token %s in request header for user %s", refreshToken, req.getRemoteAddr()));
            return refreshToken;
        }
        return null;
    }

    public static final void saveRefreshToken(String prefix, String refreshToken, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        DEFAULT_LOGGER.debug(String.format("Saving refresh token %s in session %s for user %s", refreshToken, session.getId(), req.getRemoteAddr()));
        if (Preconditions.isEmptyString((String)refreshToken)) {
            session.removeAttribute(prefix + ".credential.refresh_token");
        }
        session.setAttribute(prefix + ".credential.refresh_token", (Object)refreshToken);
    }

    public static final void removeRefreshToken(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        SocialUtils.saveRefreshToken(prefix, null, req, resp);
    }

    public static final OAuthCredential loadOAuthCredential(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        String idToken = SocialUtils.loadIdToken(prefix, req, resp);
        String refreshToken = SocialUtils.loadRefreshToken(prefix, req, resp);
        OAuthCredential credential = new OAuthCredential(null, null);
        if (!Preconditions.isEmptyString((String)refreshToken)) {
            credential.setRefreshToken(refreshToken);
        }
        HashMap<String, String> extraParams = null;
        if (!Preconditions.isEmptyString((String)idToken)) {
            extraParams = new HashMap<String, String>();
            extraParams.put("id_token", idToken);
            credential.setExtraParams(extraParams);
        }
        credential.setAccessTokenExpiration(System.currentTimeMillis() / 1000L + OAuthCredential.DEFAULT_ACCESS_TOKEN_EXPIRES_IN_SEC);
        DEFAULT_LOGGER.debug(String.format("Loaded OAuth credential %s for user %s", credential, req.getRemoteAddr()));
        return credential;
    }

    public static final void saveOAuthCredential(String prefix, OAuthCredential credential, HttpServletRequest req, HttpServletResponse resp) {
        if (credential == null) {
            SocialUtils.removeIdToken(prefix, req, resp);
            SocialUtils.removeRefreshToken(prefix, req, resp);
            return;
        }
        if (credential.getExtraParams() != null && !credential.getExtraParams().isEmpty()) {
            SocialUtils.saveIdToken(prefix, (String)credential.getExtraParams().get("id_token"), req, resp);
        }
        if (!Preconditions.isEmptyString((String)credential.getRefreshToken())) {
            SocialUtils.saveRefreshToken(prefix, credential.getRefreshToken(), req, resp);
        }
    }

    public static final void removeOAuthCredential(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        SocialUtils.saveOAuthCredential(prefix, null, req, resp);
    }

    public static final UserAccount<?> loadUserAccount(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Object curUser = session.getAttribute("social.currentUser");
        UserAccount userAccount = curUser instanceof UserAccount ? (UserAccount)curUser : null;
        return userAccount;
    }

    public static final void saveUserAccount(UserAccount<?> userAccount, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        DEFAULT_LOGGER.debug(String.format("Saving user account %s in session for user %s.", userAccount, request.getRemoteAddr()));
        if (userAccount == null || !BaseSocialAccount.isValid((BaseSocialAccount)userAccount.getSocialAccount())) {
            session.removeAttribute("social.currentUser");
            return;
        }
        session.setAttribute("social.currentUser", userAccount);
        SocialUtils.saveOAuthCredential(userAccount.getSocialAccount().getProvider(), userAccount.getSocialAccount().getCredential(), request, response);
    }

    public static final String loadLastUrl(HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        Object lastUrl = session.getAttribute("social.last_url");
        if (lastUrl != null && !Preconditions.isEmptyString((String)lastUrl.toString())) {
            String url = lastUrl.toString();
            DEFAULT_LOGGER.debug(String.format("Found last url %s in session %s for user %s", url, session.getId(), req.getRemoteAddr()));
            return url;
        }
        String url = CookieUtils.getCookieValue((String)"social.last_url", (HttpServletRequest)req);
        if (url != null && !Preconditions.isEmptyString((String)url)) {
            DEFAULT_LOGGER.debug(String.format("Found last url %s in cookies for user %s", url, req.getRemoteAddr()));
            return url;
        }
        url = req.getContextPath();
        if (Preconditions.isEmptyString((String)url.toString())) {
            url = "/";
        }
        DEFAULT_LOGGER.debug(String.format("No valid last url in session %s for user %s, using calculated context path %s", session.getId(), req.getRemoteAddr(), url));
        return url;
    }

    public static final String saveLastUrl(HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        String completeURL = ServletUtils.getRequestFullUrl((HttpServletRequest)req);
        DEFAULT_LOGGER.debug(String.format("Saving last url %s in session %s for user %s.", completeURL, session.getId(), req.getRemoteAddr()));
        session.setAttribute("social.last_url", (Object)completeURL);
        DEFAULT_LOGGER.debug(String.format("Saving last url %s in cookies for user %s.", completeURL, req.getRemoteAddr()));
        CookieUtils.putCookie((String)"social.last_url", (String)completeURL, (int)DEFAULT_COOKIE_EXPIRES_IN_SEC_SOCIAL_LAST_URL, (HttpServletRequest)req, (HttpServletResponse)resp);
        return completeURL;
    }
}

