/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.social.web.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.common.web.utils.CookieUtils;
import org.isuper.oauth.core.OAuthCredential;
import org.isuper.social.core.SocialAccount;

public final class SocialUtils {
    public static final String PATH_USER_VERIFY = "/user/verify";
    public static final String PATH_SIGNOUT = "/signout";
    private static final Logger DEFAULT_LOGGER = LogManager.getLogger((String)SocialUtils.class.getName());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(JSON_FACTORY);
    private static int DEFAULT_COOKIE_EXPIRES_IN_SEC_ID_TOKEN = (int)TimeUnit.HOURS.toSeconds(1L);

    public static final void saveSocialAccount(SocialAccount socialAccount, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        if (socialAccount == null || !socialAccount.isValid()) {
            DEFAULT_LOGGER.trace(String.format("Invalid social account %s, skip saving in session %s for user %s.", socialAccount, session.getId(), req.getRemoteAddr()));
            return;
        }
        DEFAULT_LOGGER.trace(String.format("Saving social account %s in session %s for user %s.", socialAccount, session.getId(), req.getRemoteAddr()));
        session.setAttribute("social.account", (Object)socialAccount);
        SocialUtils.saveOAuthCredential(socialAccount.getProvider(), socialAccount.getCredential(), req, resp);
    }

    public static final void removeSocialAccount(HttpServletRequest req, HttpServletResponse resp) {
        SocialAccount socialAcc = SocialUtils.loadSocialAccount(req, resp);
        if (socialAcc != null && socialAcc.isValid()) {
            SocialUtils.removeOAuthCredential(socialAcc.getProvider(), req, resp);
        }
        HttpSession session = req.getSession();
        DEFAULT_LOGGER.trace(String.format("Removing social account in session %s for user %s.", session.getId(), req.getRemoteAddr()));
        session.removeAttribute("social.account");
    }

    public static final SocialAccount loadSocialAccount(HttpServletRequest req, HttpServletResponse resp) {
        SocialAccount userAccount;
        HttpSession session = req.getSession();
        Object curUser = session.getAttribute("social.account");
        if (curUser instanceof SocialAccount) {
            userAccount = (SocialAccount)curUser;
            DEFAULT_LOGGER.trace(String.format("Loaded social account %s in session  %s for user %s.", userAccount, session.getId(), req.getRemoteAddr()));
        } else {
            userAccount = null;
            DEFAULT_LOGGER.trace(String.format("No social account found in session %s for user %s.", session.getId(), req.getRemoteAddr()));
        }
        return userAccount;
    }

    public static final void saveOAuthCredential(String prefix, OAuthCredential credential, HttpServletRequest req, HttpServletResponse resp) {
        if (Preconditions.isEmptyString((String)prefix)) {
            return;
        }
        HttpSession session = req.getSession();
        if (credential == null) {
            DEFAULT_LOGGER.trace(String.format("Invalid OAuthCredential %s, skip saving in session %s for user %s.", credential, session.getId(), req.getRemoteAddr()));
            return;
        }
        DEFAULT_LOGGER.trace(String.format("Saving OAuthCredential %s in session %s for user %s.", credential, session.getId(), req.getRemoteAddr()));
        session.setAttribute(prefix + ".credential", (Object)credential);
        if (credential.getExtraParams() != null && !credential.getExtraParams().isEmpty()) {
            SocialUtils.saveIdToken(prefix, (String)credential.getExtraParams().get("id_token"), req, resp);
        }
    }

    public static final void removeOAuthCredential(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        DEFAULT_LOGGER.trace(String.format("Removing OAuthCredential in session %s for user %s.", session.getId(), req.getRemoteAddr()));
        session.removeAttribute(prefix + ".credential");
        DEFAULT_LOGGER.trace(String.format("Removing ID token in cookies for user %s.", req.getRemoteAddr()));
        CookieUtils.removeCookie((String)(prefix + ".credential.id_token"), (HttpServletRequest)req, (HttpServletResponse)resp);
    }

    public static final OAuthCredential loadOAuthCredential(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        OAuthCredential credential = null;
        Object sessionCredential = session.getAttribute(prefix + ".credential");
        if (sessionCredential instanceof OAuthCredential) {
            credential = (OAuthCredential)sessionCredential;
            DEFAULT_LOGGER.trace(String.format("Loaded OAuth credential %s in session %s for user %s", credential, session.getId(), req.getRemoteAddr()));
            return credential;
        }
        DEFAULT_LOGGER.trace(String.format("No OAuth credential found in session %s for user %s", session.getId(), req.getRemoteAddr()));
        String refreshToken = SocialUtils.loadRefreshToken(prefix, req, resp);
        String idToken = SocialUtils.loadIdToken(prefix, req, resp);
        if (Preconditions.isEmptyString((String)refreshToken) && Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.trace(String.format("No valid refresh token and ID token found for user %s", req.getRemoteAddr()));
            return credential;
        }
        credential = new OAuthCredential(null, null);
        credential.setAccessTokenExpiration(System.currentTimeMillis() / 1000L + OAuthCredential.DEFAULT_ACCESS_TOKEN_EXPIRES_IN_SEC);
        if (!Preconditions.isEmptyString((String)refreshToken)) {
            credential.setRefreshToken(refreshToken);
        }
        if (!Preconditions.isEmptyString((String)idToken)) {
            HashMap<String, String> extraParams = new HashMap<String, String>();
            extraParams.put("id_token", idToken);
            credential.setExtraParams(extraParams);
        }
        DEFAULT_LOGGER.trace(String.format("Loaded OAuth credential %s for user %s", credential, req.getRemoteAddr()));
        return credential;
    }

    private static final void saveIdToken(String prefix, String idToken, HttpServletRequest req, HttpServletResponse resp) {
        if (Preconditions.isEmptyString((String)prefix) || Preconditions.isEmptyString((String)idToken)) {
            return;
        }
        DEFAULT_LOGGER.trace(String.format("Saving ID token %s in cookies for user %s.", idToken, req.getRemoteAddr()));
        CookieUtils.putCookie((String)(prefix + ".credential.id_token"), (String)idToken, (int)DEFAULT_COOKIE_EXPIRES_IN_SEC_ID_TOKEN, (HttpServletRequest)req, (HttpServletResponse)resp);
    }

    private static final String loadIdToken(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        String idToken = req.getHeader(prefix + ".credential.id_token");
        if (!Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.trace(String.format("Found ID token %s in request header for user %s", idToken, req.getRemoteAddr()));
            return idToken;
        }
        idToken = req.getParameter(prefix + ".credential.id_token");
        if (!Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.trace(String.format("Found ID token %s in request body for user %s", idToken, req.getRemoteAddr()));
            return idToken;
        }
        idToken = CookieUtils.getCookieValue((String)(prefix + ".credential.id_token"), (HttpServletRequest)req);
        if (!Preconditions.isEmptyString((String)idToken)) {
            DEFAULT_LOGGER.trace(String.format("Found ID token %s in cookies for user %s", idToken, req.getRemoteAddr()));
            return idToken;
        }
        DEFAULT_LOGGER.trace(String.format("No ID token found in both request header and body even cookies for user %s", req.getRemoteAddr()));
        return null;
    }

    private static final String loadRefreshToken(String prefix, HttpServletRequest req, HttpServletResponse resp) {
        String refreshToken = req.getHeader(prefix + ".credential.refresh_token");
        if (!Preconditions.isEmptyString((String)refreshToken)) {
            DEFAULT_LOGGER.trace(String.format("Found refresh token %s in request header for user %s", refreshToken, req.getRemoteAddr()));
            return refreshToken;
        }
        refreshToken = req.getParameter(prefix + ".credential.refresh_token");
        if (!Preconditions.isEmptyString((String)refreshToken)) {
            DEFAULT_LOGGER.trace(String.format("Found refresh token %s in request body for user %s", refreshToken, req.getRemoteAddr()));
            return refreshToken;
        }
        DEFAULT_LOGGER.trace(String.format("No refresh token found in both request header and body for user %s", req.getRemoteAddr()));
        return null;
    }

    public static JsonFactory getJsonFactory() {
        return JSON_FACTORY;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static Logger getLogger() {
        return DEFAULT_LOGGER;
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)name);
    }
}

