/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.httpclient.AsyncHttpClient;

public class TelegramClient
implements Closeable {
    private static final Logger LOG = LogManager.getLogger((String)"telegram-client");
    private final AsyncHttpClient client;

    public TelegramClient() {
        this(null, 1080);
    }

    public TelegramClient(String proxyHostname, int proxyPort) {
        try {
            this.client = AsyncHttpClient.newInstance((String)proxyHostname, (int)proxyPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendMessageToMultipleTelegramChats(String token, Long[] chatIDs, String msg, boolean useMarkdown, boolean disablePreview) {
        if (chatIDs == null || chatIDs.length < 1) {
            return;
        }
        Long[] longArray = chatIDs;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long chatID = longArray[i];
            this.sendMessageToSingleTelegramChat(token, chatID, msg, useMarkdown, disablePreview);
        }
    }

    public void sendMessageToSingleTelegramChat(String token, long chatID, String msg) {
        this.sendMessageToSingleTelegramChat(token, chatID, msg, false, false);
    }

    public void sendMessageToSingleTelegramChat(String token, long chatID, String msg, boolean useMarkdown, boolean disablePreview) {
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", "" + chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + msg));
        if (useMarkdown) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", "Markdown"));
        }
        items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        this.sendMessage(token, items);
    }

    public void sendReplyMessage(String token, Long chatID, long replyTo, String msg) {
        this.sendReplyMessage(token, chatID.toString(), replyTo, msg, false, false);
    }

    public void sendReplyMessage(String token, String chatID, long replyTo, String msg) {
        this.sendReplyMessage(token, chatID, replyTo, msg, false, false);
    }

    public void sendReplyMessage(String token, String chatID, long replyTo, String msg, boolean useMarkdown, boolean disablePreview) {
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + msg));
        if (useMarkdown) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", "Markdown"));
        }
        items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        items.add((NameValuePair)new BasicNameValuePair("reply_to_message_id", "" + replyTo));
        this.sendMessage(token, items);
    }

    private void sendMessage(String token, List<NameValuePair> items) {
        try {
            HttpPost post = new HttpPost("https://api.telegram.org/bot" + token + "/sendMessage");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(items, "UTF-8"));
            LOG.trace((Object)post.getRequestLine());
            Future future = this.client.execute((HttpUriRequest)post, null);
            HttpResponse resp = (HttpResponse)future.get();
            StatusLine status = resp.getStatusLine();
            HttpEntity entity = resp.getEntity();
            String contentType = entity.getContentType().getValue();
            String content = EntityUtils.toString((HttpEntity)entity);
            LOG.trace((Object)resp.getStatusLine());
            LOG.trace(contentType);
            LOG.trace(content);
            if (status.getStatusCode() != 200) {
                throw new IOException(String.format("%d response received from server: %s", status.getStatusCode(), content));
            }
        }
        catch (IOException | IllegalStateException | InterruptedException | ExecutionException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

