/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.httpclient.AsyncHttpClient;

public class TelegramClient
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"telegram-client");
    private static final TelegramAsyncResponseHandler DEFAULT_ASYNC_RESPONSE_HANDLER = new TelegramAsyncResponseHandler();
    private final AsyncHttpClient client;

    public TelegramClient() {
        this(null, 1080);
    }

    public TelegramClient(String proxyHostname, int proxyPort) {
        try {
            this.client = AsyncHttpClient.newInstance((String)proxyHostname, (int)proxyPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendMessage(String token, String chatID, String msg) {
        this.sendMessage(token, chatID, msg, false, false);
    }

    public void sendMessage(String token, String chatID, String msg, boolean useMarkdown, boolean disablePreview) {
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", "" + chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + msg));
        if (useMarkdown) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", "Markdown"));
        }
        items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        this.send(token, items);
    }

    public void replyMessage(String token, String chatID, long replyTo, String msg) {
        this.replyMessage(token, chatID, replyTo, msg, false, false);
    }

    public void replyMessage(String token, String chatID, long replyTo, String msg, boolean useMarkdown, boolean disablePreview) {
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + msg));
        if (useMarkdown) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", "Markdown"));
        }
        items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        items.add((NameValuePair)new BasicNameValuePair("reply_to_message_id", "" + replyTo));
        this.send(token, items);
    }

    private void send(String token, List<NameValuePair> items) {
        HttpPost post = new HttpPost("https://api.telegram.org/bot" + token + "/sendMessage");
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(items, Charset.forName("UTF-8")));
        LOGGER.trace((Object)post.getRequestLine());
        this.client.execute((HttpUriRequest)post, (FutureCallback)DEFAULT_ASYNC_RESPONSE_HANDLER);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static class TelegramAsyncResponseHandler
    implements FutureCallback<HttpResponse> {
        private TelegramAsyncResponseHandler() {
        }

        public void completed(HttpResponse resp) {
            StatusLine status = resp.getStatusLine();
            LOGGER.trace((Object)resp.getStatusLine());
            HttpEntity entity = resp.getEntity();
            String contentType = entity.getContentType().getValue();
            LOGGER.trace(contentType);
            try {
                String content = EntityUtils.toString((HttpEntity)entity);
                LOGGER.trace(content);
                if (status.getStatusCode() != 200) {
                    LOGGER.warn(String.format("%d response received from server: %s", status.getStatusCode(), content));
                }
            }
            catch (IOException | ParseException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }

        public void failed(Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }

        public void cancelled() {
            LOGGER.error("Request to telegram server has been canncelled.");
        }
    }
}

