/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.httpclient.AsyncHttpClient;
import org.isuper.telegram.BadRequestException;
import org.isuper.telegram.BotRemovedException;
import org.isuper.telegram.TooManyRequestsException;
import org.isuper.telegram.models.InlineQueryResult;
import org.isuper.telegram.models.MessageParseMode;
import org.isuper.telegram.utils.TelegramUtils;

public class TelegramClient
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"telegram-client");
    private final AsyncHttpClient client;

    public TelegramClient() {
        this(null, 1080);
    }

    public TelegramClient(String proxyHostname, int proxyPort) {
        try {
            this.client = AsyncHttpClient.newInstance((String)proxyHostname, (int)proxyPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendMessage(String token, String chatID, String msg) {
        this.sendMessage(token, chatID, msg, null, false);
    }

    public void sendMessage(String token, String chatID, String msg, MessageParseMode parseMode, boolean disablePreview) {
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", "" + chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + msg));
        if (parseMode != null) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", parseMode.name()));
        }
        items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        this.sendRepeatly(token, "sendMessage", items);
    }

    public void replyMessage(String token, String chatID, long replyTo, String msg) {
        this.replyMessage(token, chatID, replyTo, msg, null, false);
    }

    public void replyMessage(String token, String chatID, long replyTo, String msg, MessageParseMode parseMode, boolean disablePreview) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        if (Preconditions.isEmptyString((String)msg)) {
            return;
        }
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + msg));
        if (parseMode != null) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", parseMode.name()));
        }
        items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        items.add((NameValuePair)new BasicNameValuePair("reply_to_message_id", "" + replyTo));
        this.sendRepeatly(token, "sendMessage", items);
    }

    public void answerInlineQuery(String token, String queryID, Collection<InlineQueryResult> results) {
        this.answerInlineQuery(token, queryID, results, null, null, null);
    }

    public void answerInlineQuery(String token, String queryID, Collection<InlineQueryResult> results, Integer cacheTime, Boolean personal, String nextOffset) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)queryID, (String)"Answered query ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("inline_query_id", queryID));
        try {
            if (results == null) {
                items.add((NameValuePair)new BasicNameValuePair("results", TelegramUtils.getObjectMapper().writeValueAsString(Collections.emptyList())));
            } else {
                items.add((NameValuePair)new BasicNameValuePair("results", TelegramUtils.getObjectMapper().writeValueAsString(results)));
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            items.add((NameValuePair)new BasicNameValuePair("results", "[]"));
        }
        if (cacheTime != null) {
            items.add((NameValuePair)new BasicNameValuePair("cache_time", cacheTime.toString()));
        }
        if (personal != null) {
            items.add((NameValuePair)new BasicNameValuePair("is_personal", personal.toString()));
        }
        if (!Preconditions.isEmptyString((String)nextOffset)) {
            items.add((NameValuePair)new BasicNameValuePair("next_offset", nextOffset));
        }
        try {
            this.send(token, "answerInlineQuery", items);
        }
        catch (IOException | InterruptedException | ExecutionException | BadRequestException | BotRemovedException | TooManyRequestsException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void sendRepeatly(String token, String endpoint, List<NameValuePair> items) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        int interval = 1;
        try {
            while (!Thread.interrupted()) {
                try {
                    this.send(token, endpoint, items);
                    break;
                }
                catch (BotRemovedException e) {
                    LOGGER.error(e.getMessage());
                    break;
                }
                catch (BadRequestException e) {
                    LOGGER.error(String.format("%s: %s", e.getMessage(), e.getRequestFormItems()));
                    break;
                }
                catch (Exception e) {
                    if (interval > 17) {
                        interval = 17;
                    }
                    TimeUnit.SECONDS.sleep(interval);
                    LOGGER.warn(String.format("Failed to send response back to telegram server because of %s, retry after %d second(s).", e.getMessage(), interval++));
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOGGER.info("Cancelling ...");
        }
    }

    private void send(String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, BotRemovedException, BadRequestException, TooManyRequestsException {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)endpoint, (String)"Telegram endpoint should be provided.");
        if (items == null || items.isEmpty()) {
            return;
        }
        HttpPost post = new HttpPost(String.format("https://api.telegram.org/bot%s/%s", token, endpoint));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(items, Charset.forName("UTF-8")));
        LOGGER.trace((Object)post.getRequestLine());
        HttpResponse resp = (HttpResponse)this.client.execute((HttpRequestBase)post, null).get();
        StatusLine status = resp.getStatusLine();
        LOGGER.trace((Object)resp.getStatusLine());
        HttpEntity entity = resp.getEntity();
        String contentType = entity.getContentType().getValue();
        LOGGER.trace(contentType);
        String content = EntityUtils.toString((HttpEntity)entity);
        LOGGER.trace(content);
        if (status.getStatusCode() == 400) {
            throw new BadRequestException(content, items);
        }
        if (status.getStatusCode() == 403) {
            throw new BotRemovedException(content);
        }
        if (status.getStatusCode() == 429) {
            throw new TooManyRequestsException(content);
        }
        if (status.getStatusCode() != 200) {
            throw new IOException(String.format("%d response received from server: %s", status.getStatusCode(), content));
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

