/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.httpclient.AsyncHttpClient;
import org.isuper.telegram.BadRequestException;
import org.isuper.telegram.BotRemovedException;
import org.isuper.telegram.TooManyRequestsException;
import org.isuper.telegram.models.Chat;
import org.isuper.telegram.models.ChatMember;
import org.isuper.telegram.models.InlineQueryResult;
import org.isuper.telegram.models.Message;
import org.isuper.telegram.models.MessageParseMode;
import org.isuper.telegram.models.User;
import org.isuper.telegram.utils.TelegramUtils;

public class TelegramClient
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"telegram-client");
    private static final int MAX_RETRY = 20;
    private final AsyncHttpClient client;

    public TelegramClient() {
        this(null, 1080);
    }

    public TelegramClient(String proxyHostname, int proxyPort) {
        try {
            this.client = AsyncHttpClient.newInstance((String)proxyHostname, (int)proxyPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public User getMe(String token) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        return this.getResourceRepeatly(User.class, token, "getMe", null);
    }

    public Message sendMessage(String token, String chatID, String text) {
        return this.sendMessage(token, chatID, text, null);
    }

    public Message sendMessage(String token, String chatID, String text, Long replyTo) {
        return this.sendMessage(token, chatID, text, null, false, false, replyTo);
    }

    public Message sendMessage(String token, String chatID, String text, MessageParseMode parseMode, boolean disablePreview) {
        return this.sendMessage(token, chatID, text, parseMode, disablePreview, null, null);
    }

    public Message sendMessage(String token, String chatID, String text, MessageParseMode parseMode, Boolean disablePreview, Boolean disableNotification, Long replyTo) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        if (Preconditions.isEmptyString((String)text)) {
            return null;
        }
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + text));
        if (parseMode != null) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", parseMode.name()));
        }
        if (disablePreview != null) {
            items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        }
        if (disableNotification != null) {
            items.add((NameValuePair)new BasicNameValuePair("disable_notification", "" + disablePreview));
        }
        if (replyTo != null) {
            items.add((NameValuePair)new BasicNameValuePair("reply_to_message_id", "" + replyTo));
        }
        return this.getResourceRepeatly(Message.class, token, "sendMessage", items);
    }

    public Message forwardMessage(String token, String chatID, String fromChatID, Boolean disableNotification, long messageID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        LinkedList<BasicNameValuePair> items = new LinkedList<BasicNameValuePair>();
        items.add(new BasicNameValuePair("chat_id", chatID));
        items.add(new BasicNameValuePair("from_chat_id", fromChatID));
        items.add(new BasicNameValuePair("message_id", "" + messageID));
        if (disableNotification != null) {
            items.add(new BasicNameValuePair("disable_notification", disableNotification.toString()));
        }
        return this.getResourceRepeatly(Message.class, token, "forwardMessage", null);
    }

    public boolean kickChatMember(String token, String chatID, long userID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("user_id", "" + userID));
        return this.getResourceRepeatly(Boolean.class, token, "kickChatMember", items);
    }

    public boolean leaveChat(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourceRepeatly(Boolean.class, token, "leaveChat", items);
    }

    public boolean unbanChatMember(String token, String chatID, long userID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Answered query ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("user_id", "" + userID));
        return this.getResourceRepeatly(Boolean.class, token, "unbanChatMember", items);
    }

    public Chat getChat(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourceRepeatly(Chat.class, token, "getChat", items);
    }

    public List<ChatMember> getChatAdministrators(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourcesRepeatly(ChatMember.class, null, token, "getChatAdministrators", items);
    }

    public int getChatMembersCount(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourceRepeatly(Integer.class, token, "getChatMembersCount", items);
    }

    public List<ChatMember> getChatMember(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourcesRepeatly(ChatMember.class, null, token, "getChatMember", items);
    }

    public void answerInlineQuery(String token, String queryID, Collection<InlineQueryResult> results) {
        this.answerInlineQuery(token, queryID, results, null, null, null);
    }

    public void answerInlineQuery(String token, String queryID, Collection<InlineQueryResult> results, Integer cacheTime, Boolean personal, String nextOffset) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)queryID, (String)"Answered query ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("inline_query_id", queryID));
        try {
            if (results == null) {
                items.add((NameValuePair)new BasicNameValuePair("results", TelegramUtils.getObjectMapper().writeValueAsString(Collections.emptyList())));
            } else {
                items.add((NameValuePair)new BasicNameValuePair("results", TelegramUtils.getObjectMapper().writeValueAsString(results)));
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            items.add((NameValuePair)new BasicNameValuePair("results", "[]"));
        }
        if (cacheTime != null) {
            items.add((NameValuePair)new BasicNameValuePair("cache_time", cacheTime.toString()));
        }
        if (personal != null) {
            items.add((NameValuePair)new BasicNameValuePair("is_personal", personal.toString()));
        }
        if (!Preconditions.isEmptyString((String)nextOffset)) {
            items.add((NameValuePair)new BasicNameValuePair("next_offset", nextOffset));
        }
        try {
            this.send(token, "answerInlineQuery", items);
        }
        catch (IOException | InterruptedException | ExecutionException | BadRequestException | BotRemovedException | TooManyRequestsException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private <T> List<T> getResourcesRepeatly(Class<T> resultClass, String treeKey, String token, String endpoint, List<NameValuePair> items) {
        int retry = 0;
        int interval = 0;
        try {
            while (!Thread.interrupted()) {
                try {
                    return this.getResources(resultClass, treeKey, token, endpoint, items);
                }
                catch (BotRemovedException e) {
                    LOGGER.error(e.getMessage());
                    break;
                }
                catch (BadRequestException e) {
                    LOGGER.error(String.format("%s: %s", e.getMessage(), e.getRequestFormItems()));
                    break;
                }
                catch (Exception e) {
                    if (interval > 17) {
                        interval = 17;
                    }
                    if (retry < 20) {
                        LOGGER.warn(String.format("Failed to get resource from telegram server because of %s, retry after %d second(s).", e.getMessage(), interval++));
                    }
                    TimeUnit.SECONDS.sleep(interval);
                    if (retry < 20) continue;
                    LOGGER.warn(String.format("Maximium retry count %d reached, failed to get resource from telegram server.", retry));
                    break;
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOGGER.info("Cancelling ...");
        }
        return Collections.emptyList();
    }

    private <T> List<T> getResources(Class<T> resultClass, String treeKey, String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, BotRemovedException, BadRequestException, TooManyRequestsException {
        JsonNode node = this.send(token, endpoint, items);
        if (Preconditions.isEmptyString((String)treeKey)) {
            return (List)TelegramUtils.getObjectMapper().readValue(node.traverse(), (JavaType)TelegramUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, resultClass));
        }
        if (node == null || !node.hasNonNull(treeKey)) {
            return Collections.emptyList();
        }
        return (List)TelegramUtils.getObjectMapper().readValue(node.get(treeKey).traverse(), (JavaType)TelegramUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, resultClass));
    }

    private <T> T getResourceRepeatly(Class<T> resultClass, String token, String endpoint, List<NameValuePair> items) {
        int retry = 0;
        int interval = 0;
        try {
            while (!Thread.interrupted()) {
                try {
                    return this.getResource(resultClass, token, endpoint, items);
                }
                catch (BotRemovedException e) {
                    LOGGER.error(e.getMessage());
                    break;
                }
                catch (BadRequestException e) {
                    LOGGER.error(String.format("%s: %s", e.getMessage(), e.getRequestFormItems()));
                    break;
                }
                catch (Exception e) {
                    if (interval > 17) {
                        interval = 17;
                    }
                    if (retry < 20) {
                        LOGGER.warn(String.format("Failed to get resource from telegram server because of %s, retry after %d second(s).", e.getMessage(), interval++));
                    }
                    TimeUnit.SECONDS.sleep(interval);
                    if (retry < 20) continue;
                    LOGGER.warn(String.format("Maximium retry count %d reached, failed to get resource from telegram server.", retry));
                    break;
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOGGER.info("Cancelling ...");
        }
        return null;
    }

    private <T> T getResource(Class<T> resultClass, String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, BotRemovedException, BadRequestException, TooManyRequestsException {
        JsonNode node = this.send(token, endpoint, items);
        if (node == null) {
            return null;
        }
        return (T)TelegramUtils.getObjectMapper().treeToValue((TreeNode)node, resultClass);
    }

    private JsonNode send(String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, BotRemovedException, BadRequestException, TooManyRequestsException {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)endpoint, (String)"Telegram endpoint should be provided.");
        HttpPost post = new HttpPost(String.format("https://api.telegram.org/bot%s/%s", token, endpoint));
        if (items != null && !items.isEmpty()) {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(items, Charset.forName("UTF-8")));
        }
        LOGGER.trace((Object)post.getRequestLine());
        HttpResponse resp = (HttpResponse)this.client.execute((HttpRequestBase)post, null).get();
        StatusLine status = resp.getStatusLine();
        LOGGER.trace((Object)resp.getStatusLine());
        HttpEntity entity = resp.getEntity();
        String contentType = entity.getContentType().getValue();
        LOGGER.trace(contentType);
        String content = EntityUtils.toString((HttpEntity)entity);
        LOGGER.trace(content);
        if (status.getStatusCode() == 400) {
            throw new BadRequestException(content, items);
        }
        if (status.getStatusCode() == 403) {
            throw new BotRemovedException(content);
        }
        if (status.getStatusCode() == 429) {
            throw new TooManyRequestsException(content);
        }
        if (status.getStatusCode() != 200) {
            throw new IOException(String.format("%d response received from server: %s", status.getStatusCode(), content));
        }
        return TelegramUtils.getObjectMapper().readTree(content);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

