/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.ChatType;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Chat
implements Serializable {
    private static final long serialVersionUID = 4478241009092585429L;
    public final long id;
    public final ChatType type;
    public final String title;
    public final String username;
    public final String firstName;
    public final String lastName;

    @JsonCreator
    public Chat(@JsonProperty(value="id") long id, @JsonProperty(value="type") ChatType type, @JsonProperty(value="title") String title, @JsonProperty(value="username") String username, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName) {
        if ((double)Math.abs(id) > 1.0E13) {
            throw new IllegalArgumentException(String.format("Unique identifier for this chat should not exceeding 1e13 by absolute value, but got %d", id));
        }
        this.id = id;
        Preconditions.notNull((Object)((Object)type), (String)"ChatType should not be null!");
        this.type = type;
        this.title = title;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chat other = (Chat)obj;
        return this.id == other.id;
    }

    public String toString() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }
}

