/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Location {
    public final float latitude;
    public final float longitude;

    @JsonCreator
    public Location(@JsonProperty(value="latitude") float latitude, @JsonProperty(value="longitude") float longitude) {
        if (Math.abs(latitude) > 90.0f) {
            throw new IllegalArgumentException(String.format("Invalid latitude %f", Float.valueOf(latitude)));
        }
        this.latitude = latitude;
        if (Math.abs(longitude) > 180.0f) {
            throw new IllegalArgumentException(String.format("Invalid longitude %f", Float.valueOf(longitude)));
        }
        this.longitude = longitude;
    }

    public String toString() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }
}

