/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.Command;
import org.isuper.telegram.models.Message;
import org.isuper.telegram.models.Update;
import org.isuper.telegram.models.inline.ChosenInlineResult;
import org.isuper.telegram.models.inline.InlineQuery;
import org.isuper.telegram.utils.TelegramUtils;

public abstract class TelegramRobot {
    protected void handleUpdate(Update update) {
        if (update == null) {
            return;
        }
        ResourceBundle bundle = this.getResourceBundle(update);
        if (update.inlineQuery != null) {
            this.handleInlineQuery(bundle, update.inlineQuery);
        } else if (update.chosenInlineResult != null) {
            this.handleChosenInlineResult(bundle, update.chosenInlineResult);
        } else if (update.message != null) {
            if (update.message.newChatParticipant != null) {
                this.handleNewParticipant(bundle, update.message);
            } else if (update.message.location != null) {
                this.handleLocationMessage(bundle, update.message);
            } else if (!Preconditions.isEmptyString((String)update.message.text)) {
                Command cmd = TelegramUtils.parseCommandFromText(update.message.text);
                if (cmd == null) {
                    this.handleOrdinaryTextMessage(bundle, update.message);
                } else if (Preconditions.isEmptyString((String)cmd.toBot) || this.getRobotUsername().equalsIgnoreCase(cmd.toBot)) {
                    this.handleCommands(bundle, cmd, update.message);
                }
            }
        } else {
            try {
                this.getLogger().warn(TelegramUtils.getObjectMapper().writeValueAsString((Object)update));
            }
            catch (JsonProcessingException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Logger getLogger() {
        return LogManager.getLogger((String)String.format("%s.bots.%s", TelegramRobot.class.getPackage().getName(), this.getRobotUsername()));
    }

    protected abstract ResourceBundle getResourceBundle(Update var1);

    protected abstract String getRobotUsername();

    protected abstract void handleNewParticipant(ResourceBundle var1, Message var2);

    protected abstract void handleLocationMessage(ResourceBundle var1, Message var2);

    protected abstract void handleOrdinaryTextMessage(ResourceBundle var1, Message var2);

    protected abstract void handleCommands(ResourceBundle var1, Command var2, Message var3);

    protected abstract void handleInlineQuery(ResourceBundle var1, InlineQuery var2);

    protected abstract void handleChosenInlineResult(ResourceBundle var1, ChosenInlineResult var2);
}

