/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models.markups;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.markups.KeyboardButton;
import org.isuper.telegram.models.markups.ReplyMarkup;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReplyKeyboardMarkup
implements ReplyMarkup {
    @JsonProperty(value="keyboard")
    public final KeyboardButton[] keyboard;
    @JsonProperty(value="resize_keyboard")
    public final boolean resizeKeyboard;
    @JsonProperty(value="one_time_Keyboard")
    public final boolean oneTimeKeyboard;
    @JsonProperty(value="selective")
    public final boolean selective;

    public ReplyKeyboardMarkup(@JsonProperty(value="keyboard") KeyboardButton[] keyboard, @JsonProperty(value="resize_keyboard") Boolean resizeKeyboard, @JsonProperty(value="one_time_Keyboard") Boolean oneTimeKeyboard, @JsonProperty(value="selective") Boolean selective) {
        Preconditions.notNull((Object)keyboard, (String)"Keyboard should be provided.");
        if (keyboard.length < 1) {
            throw new IllegalArgumentException("Keyboard should have at least one KeyButton.");
        }
        this.keyboard = keyboard;
        this.resizeKeyboard = resizeKeyboard;
        this.oneTimeKeyboard = oneTimeKeyboard;
        this.selective = selective;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

