/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.ChatType;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Chat {
    @JsonProperty(value="id")
    public final long id;
    @JsonProperty(value="type")
    public final ChatType type;
    @JsonProperty(value="title")
    public final String title;
    @JsonProperty(value="username")
    public final String username;
    @JsonProperty(value="first_name")
    public final String firstName;
    @JsonProperty(value="last_name")
    public final String lastName;

    @JsonCreator
    public Chat(@JsonProperty(value="id") Long id, @JsonProperty(value="type") ChatType type, @JsonProperty(value="title") String title, @JsonProperty(value="username") String username, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName) {
        Preconditions.notNull((Object)id, (String)"Chat ID should be provided.");
        if ((double)Math.abs(id) > 1.0E13) {
            throw new IllegalArgumentException(String.format("Unique identifier for this chat should not exceeding 1e13 by absolute value, but got %d", id));
        }
        this.id = id;
        Preconditions.notNull((Object)((Object)type), (String)"ChatType should be provided.");
        this.type = type;
        this.title = title;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

