/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.Chat;
import org.isuper.telegram.models.Contact;
import org.isuper.telegram.models.Location;
import org.isuper.telegram.models.PhotoSize;
import org.isuper.telegram.models.User;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    @JsonProperty(value="message_id")
    public final long id;
    @JsonProperty(value="from")
    public final User from;
    @JsonProperty(value="date")
    public final long date;
    @JsonProperty(value="chat")
    public final Chat chat;
    @JsonProperty(value="forward_from")
    public final User forwardFrom;
    @JsonProperty(value="forward_from_chat")
    public final Chat forwardFromChat;
    @JsonProperty(value="forward_date")
    public final Long forwardDate;
    @JsonProperty(value="reply_to_message")
    public final Message replyTo;
    @JsonProperty(value="edit_date")
    public final Long editDate;
    @JsonProperty(value="text")
    public final String text;
    @JsonProperty(value="contact")
    public final Contact contact;
    @JsonProperty(value="location")
    public final Location location;
    @JsonProperty(value="new_chat_participant")
    public final User newChatParticipant;
    @JsonProperty(value="left_chat_participant")
    public final User leftChatParticipant;
    @JsonProperty(value="new_chat_title")
    public final String newChatTitle;
    @JsonProperty(value="new_chat_photo")
    public final PhotoSize[] newChatPhoto;
    @JsonProperty(value="delete_chat_photo")
    public final Boolean deleteChatPhoto;
    @JsonProperty(value="group_chat_created")
    public final Boolean groupChatCreated;
    @JsonProperty(value="supergroup_chat_created")
    public final Boolean supergroupChatCreated;
    @JsonProperty(value="channel_chat_created")
    public final Boolean channelChatCreated;
    @JsonProperty(value="migrate_to_chat_id")
    public final Long migrateToChatID;
    @JsonProperty(value="migrate_from_chat_id")
    public final Long migrateFromChatID;
    @JsonProperty(value="pinned_message")
    public final Message pinned;

    public Message(@JsonProperty(value="message_id") Long id, @JsonProperty(value="from") User from, @JsonProperty(value="date") Long date, @JsonProperty(value="chat") Chat chat, @JsonProperty(value="forward_from") User forwardFrom, @JsonProperty(value="forward_from_chat") Chat forwardFromChat, @JsonProperty(value="forward_date") long forwardDate, @JsonProperty(value="reply_to_message") Message replyTo, @JsonProperty(value="edit_date") Long editDate, @JsonProperty(value="text") String text, @JsonProperty(value="contact") Contact contact, @JsonProperty(value="location") Location location, @JsonProperty(value="new_chat_participant") User newChatParticipant, @JsonProperty(value="left_chat_participant") User leftChatParticipant, @JsonProperty(value="new_chat_title") String newChatTitle, @JsonProperty(value="new_chat_photo") PhotoSize[] newChatPhoto, @JsonProperty(value="delete_chat_photo") Boolean deleteChatPhoto, @JsonProperty(value="group_chat_created") Boolean groupChatCreated, @JsonProperty(value="supergroup_chat_created") Boolean supergroupChatCreated, @JsonProperty(value="channel_chat_created") Boolean channelChatCreated, @JsonProperty(value="migrate_to_chat_id") Long migrateToChatID, @JsonProperty(value="migrate_from_chat_id") Long migrateFromChatID, @JsonProperty(value="pinned_message") Message pinned) {
        Preconditions.notNull((Object)id, (String)"Message ID should be provided.");
        this.id = id;
        this.from = from;
        Preconditions.notNull((Object)date, (String)"Message sent date should be provided.");
        this.date = date;
        this.chat = chat;
        this.forwardFrom = forwardFrom;
        this.forwardFromChat = forwardFromChat;
        this.forwardDate = forwardDate;
        this.replyTo = replyTo;
        this.editDate = editDate;
        this.text = text;
        this.contact = contact;
        this.location = location;
        this.newChatParticipant = newChatParticipant;
        this.leftChatParticipant = leftChatParticipant;
        this.newChatTitle = newChatTitle;
        this.newChatPhoto = newChatPhoto;
        this.deleteChatPhoto = deleteChatPhoto;
        this.groupChatCreated = groupChatCreated;
        this.supergroupChatCreated = supergroupChatCreated;
        this.channelChatCreated = channelChatCreated;
        this.migrateToChatID = migrateToChatID;
        this.migrateFromChatID = migrateFromChatID;
        this.pinned = pinned;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

