/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models.inline;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.inline.InputMessageContent;
import org.isuper.telegram.utils.TelegramUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InputContactMessageContent
implements InputMessageContent {
    @JsonProperty(value="phone_number")
    public final String phoneNumber;
    @JsonProperty(value="first_name")
    public final String firstName;
    @JsonProperty(value="last_name")
    public final String lastName;

    public InputContactMessageContent(String phoneNumber, String firstName, String lastName) {
        Preconditions.notEmptyString((String)phoneNumber, (String)"Contact's phone number should be provided.");
        this.phoneNumber = phoneNumber;
        Preconditions.notEmptyString((String)firstName, (String)"Contact's first name should be provided.");
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

