/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.exceptions.BlankResponseException;
import org.isuper.telegram.exceptions.InvalidJsonResponseException;
import org.isuper.telegram.exceptions.NotJsonResponseException;
import org.isuper.telegram.exceptions.RecoverableErrorResponseException;
import org.isuper.telegram.exceptions.UnrecoverableErrorResponseException;
import org.isuper.telegram.models.Chat;
import org.isuper.telegram.models.ChatMember;
import org.isuper.telegram.models.Message;
import org.isuper.telegram.models.MessageParseMode;
import org.isuper.telegram.models.User;
import org.isuper.telegram.models.inline.InlineQueryResult;
import org.isuper.telegram.models.markups.ReplyMarkup;
import org.isuper.telegram.utils.TelegramUtils;

public class TelegramClient
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(TelegramClient.class);
    private static final int MAX_RETRY = 20;
    private final CloseableHttpAsyncClient httpclient;

    public TelegramClient() {
        RequestConfig reqConf = RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        this.httpclient = HttpAsyncClients.custom().useSystemProperties().setDefaultCookieStore((CookieStore)new BasicCookieStore()).setDefaultRequestConfig(reqConf).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
        this.httpclient.start();
    }

    public User getMe(String token) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        return this.getResourceRepeatedly(User.class, token, "getMe", null);
    }

    public Message sendMessage(String token, String chatID, String text) {
        return this.sendMessage(token, chatID, text, null, null, null, null, null);
    }

    public Message sendMessage(String token, String chatID, String text, MessageParseMode parseMode, Boolean disablePreview, Boolean disableNotification) {
        return this.sendMessage(token, chatID, text, parseMode, disablePreview, disableNotification, null, null);
    }

    public Message sendMessage(String token, String chatID, String text, Long replyTo) {
        return this.sendMessage(token, chatID, text, null, null, null, replyTo, null);
    }

    public Message sendMessage(String token, String chatID, String text, MessageParseMode parseMode, Boolean disablePreview, Boolean disableNotification, Long replyTo, ReplyMarkup replyMarkup) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        if (Preconditions.isEmptyString((String)text)) {
            return null;
        }
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("text", "" + text));
        if (parseMode != null) {
            items.add((NameValuePair)new BasicNameValuePair("parse_mode", parseMode.name()));
        }
        if (disablePreview != null) {
            items.add((NameValuePair)new BasicNameValuePair("disable_web_page_preview", "" + disablePreview));
        }
        if (disableNotification != null) {
            items.add((NameValuePair)new BasicNameValuePair("disable_notification", "" + disableNotification));
        }
        if (replyTo != null) {
            items.add((NameValuePair)new BasicNameValuePair("reply_to_message_id", "" + replyTo));
        }
        if (replyMarkup != null) {
            try {
                items.add((NameValuePair)new BasicNameValuePair("reply_markup", TelegramUtils.getObjectMapper().writeValueAsString((Object)replyMarkup)));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.getResourceRepeatedly(Message.class, token, "sendMessage", items);
    }

    public Message forwardMessage(String token, String chatID, String fromChatID, Boolean disableNotification, long messageID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        LinkedList<BasicNameValuePair> items = new LinkedList<BasicNameValuePair>();
        items.add(new BasicNameValuePair("chat_id", chatID));
        items.add(new BasicNameValuePair("from_chat_id", fromChatID));
        items.add(new BasicNameValuePair("message_id", "" + messageID));
        if (disableNotification != null) {
            items.add(new BasicNameValuePair("disable_notification", disableNotification.toString()));
        }
        return this.getResourceRepeatedly(Message.class, token, "forwardMessage", null);
    }

    public boolean kickChatMember(String token, String chatID, long userID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("user_id", "" + userID));
        return this.getResourceRepeatedly(Boolean.class, token, "kickChatMember", items);
    }

    public boolean leaveChat(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourceRepeatedly(Boolean.class, token, "leaveChat", items);
    }

    public boolean unbanChatMember(String token, String chatID, long userID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Answered query ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("user_id", "" + userID));
        return this.getResourceRepeatedly(Boolean.class, token, "unbanChatMember", items);
    }

    public Chat getChat(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourceRepeatedly(Chat.class, token, "getChat", items);
    }

    public List<ChatMember> getChatAdministrators(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourcesRepeatedly(ChatMember.class, token, "getChatAdministrators", items);
    }

    public int getChatMembersCount(String token, String chatID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        return this.getResourceRepeatedly(Integer.class, token, "getChatMembersCount", items);
    }

    public ChatMember getChatMember(String token, String chatID, long userID) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)chatID, (String)"Chat ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("chat_id", chatID));
        items.add((NameValuePair)new BasicNameValuePair("user_id", "" + userID));
        return this.getResourceRepeatedly(ChatMember.class, token, "getChatMember", items);
    }

    public void answerInlineQuery(String token, String queryID, Collection<InlineQueryResult> results) {
        this.answerInlineQuery(token, queryID, results, null, null, null);
    }

    public void answerInlineQuery(String token, String queryID, Collection<InlineQueryResult> results, Integer cacheTime, Boolean personal, String nextOffset) {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)queryID, (String)"Answered query ID should be provided.");
        LinkedList<NameValuePair> items = new LinkedList<NameValuePair>();
        items.add((NameValuePair)new BasicNameValuePair("inline_query_id", queryID));
        try {
            items.add((NameValuePair)new BasicNameValuePair("results", TelegramUtils.getObjectMapper().writeValueAsString(results == null ? Collections.emptyList() : results)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            items.add((NameValuePair)new BasicNameValuePair("results", "[]"));
        }
        if (cacheTime != null) {
            items.add((NameValuePair)new BasicNameValuePair("cache_time", cacheTime.toString()));
        }
        if (personal != null) {
            items.add((NameValuePair)new BasicNameValuePair("is_personal", personal.toString()));
        }
        if (!Preconditions.isEmptyString((String)nextOffset)) {
            items.add((NameValuePair)new BasicNameValuePair("next_offset", nextOffset));
        }
        this.getResourceRepeatedly(Boolean.class, token, "answerInlineQuery", items);
    }

    private <T> List<T> getResourcesRepeatedly(Class<T> resultClass, String token, String endpoint, List<NameValuePair> items) {
        int retry = 0;
        int interval = 0;
        try {
            while (!Thread.interrupted()) {
                try {
                    return this.getResources(resultClass, token, endpoint, items);
                }
                catch (UnrecoverableErrorResponseException e) {
                    LOGGER.error(String.format("%d: %s", e.getError().getErrorCode(), e.getError().getDescription()));
                    LOGGER.debug(String.format("%s: %s", e.getError().getDescription(), e.getRequestFormItems()));
                    break;
                }
                catch (Exception ex) {
                    if (ex instanceof RecoverableErrorResponseException) {
                        RecoverableErrorResponseException e = (RecoverableErrorResponseException)ex;
                        LOGGER.error(String.format("%d: %s", e.getError().getErrorCode(), e.getError().getDescription()));
                        LOGGER.debug(String.format("%s: %s", e.getError().getDescription(), e.getRequestFormItems()));
                    }
                    interval = interval > 17 ? 17 : ++interval;
                    if (retry++ < 20) {
                        LOGGER.warn(String.format("Failed to get resource from telegram server because of %s, retry after %d second(s).", ex.getMessage(), interval));
                        TimeUnit.SECONDS.sleep(interval);
                        continue;
                    }
                    LOGGER.warn(String.format("Maximum retry count %d reached, failed to get resource from telegram server.", retry));
                    break;
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOGGER.info("Cancelling ...");
        }
        return Collections.emptyList();
    }

    private <T> T getResourceRepeatedly(Class<T> resultClass, String token, String endpoint, List<NameValuePair> items) {
        int retry = 0;
        int interval = 0;
        try {
            while (!Thread.interrupted()) {
                try {
                    return this.getResource(resultClass, token, endpoint, items);
                }
                catch (UnrecoverableErrorResponseException e) {
                    LOGGER.error(e.getMessage());
                    LOGGER.error(String.format("%s: %s", e.getMessage(), e.getRequestFormItems()));
                    break;
                }
                catch (Exception ex) {
                    if (ex instanceof RecoverableErrorResponseException) {
                        RecoverableErrorResponseException e = (RecoverableErrorResponseException)ex;
                        LOGGER.debug(String.format("%s: %s", e.getMessage(), e.getRequestFormItems()));
                    }
                    interval = interval > 17 ? 17 : ++interval;
                    if (retry++ < 20) {
                        LOGGER.warn(String.format("Failed to get resource from telegram server because of %s, retry after %d second(s).", ex.getMessage(), interval));
                        TimeUnit.SECONDS.sleep(interval);
                        continue;
                    }
                    LOGGER.warn(String.format("Maximum retry count %d reached, failed to get resource from telegram server.", retry));
                    break;
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOGGER.info("Cancelling ...");
        }
        return null;
    }

    private <T> List<T> getResources(Class<T> resultClass, String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, RecoverableErrorResponseException, UnrecoverableErrorResponseException {
        JsonNode resultNode = this.send(token, endpoint, items);
        if (resultNode == null) {
            return Collections.emptyList();
        }
        List result = (List)TelegramUtils.getObjectMapper().readValue(resultNode.traverse(), (JavaType)TelegramUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, resultClass));
        if (result == null) {
            LOGGER.warn(String.format("Failed to parse valid list of %s from %s", resultClass, resultNode));
            result = Collections.emptyList();
        }
        return result;
    }

    private <T> T getResource(Class<T> resultClass, String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, RecoverableErrorResponseException, UnrecoverableErrorResponseException {
        JsonNode resultNode = this.send(token, endpoint, items);
        if (resultNode == null) {
            return null;
        }
        Object result = TelegramUtils.getObjectMapper().treeToValue((TreeNode)resultNode, resultClass);
        if (result == null) {
            LOGGER.warn(String.format("Failed to parse valid object of %s from %s", resultClass, resultNode));
        }
        return (T)result;
    }

    private JsonNode send(String token, String endpoint, List<NameValuePair> items) throws IOException, ExecutionException, InterruptedException, RecoverableErrorResponseException, UnrecoverableErrorResponseException {
        Preconditions.notEmptyString((String)token, (String)"Telegram token should be provided.");
        Preconditions.notEmptyString((String)endpoint, (String)"Telegram endpoint should be provided.");
        HttpPost post = new HttpPost(String.format("https://api.telegram.org/bot%s/%s", token, endpoint));
        if (items != null && !items.isEmpty()) {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(items, Charset.forName("UTF-8")));
        }
        LOGGER.trace((Object)post.getRequestLine());
        HttpResponse resp = (HttpResponse)this.httpclient.execute((HttpUriRequest)post, null).get();
        StatusLine status = resp.getStatusLine();
        LOGGER.trace((Object)resp.getStatusLine());
        HttpEntity entity = resp.getEntity();
        String contentType = entity.getContentType().getValue();
        LOGGER.trace(contentType);
        String content = EntityUtils.toString((HttpEntity)entity);
        LOGGER.trace(content);
        if (Preconditions.isEmptyString((String)content)) {
            throw new BlankResponseException(items);
        }
        if (status.getStatusCode() == 400 || status.getStatusCode() == 403 || status.getStatusCode() == 409) {
            throw new UnrecoverableErrorResponseException(content, items);
        }
        if (status.getStatusCode() != 200) {
            throw new RecoverableErrorResponseException(content, items);
        }
        JsonNode node = TelegramUtils.getObjectMapper().readTree(content);
        if (node == null) {
            throw new NotJsonResponseException(content, items);
        }
        if (!node.hasNonNull("ok") || !node.hasNonNull("result") && !node.hasNonNull("error_code")) {
            throw new InvalidJsonResponseException(content, items);
        }
        if (!node.get("ok").asBoolean() || node.hasNonNull("error_code")) {
            throw new RecoverableErrorResponseException(content, items);
        }
        return node.get("result");
    }

    @Override
    public void close() throws IOException {
        this.httpclient.close();
    }
}

