/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models.inline;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.MessageParseMode;
import org.isuper.telegram.models.inline.InputMessageContent;
import org.isuper.telegram.utils.TelegramUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InputTextMessageContent
implements InputMessageContent {
    @JsonProperty(value="message_text")
    public final String text;
    @JsonProperty(value="parse_mode")
    public final MessageParseMode parseMode;
    @JsonProperty(value="disable_web_page_preview")
    public final boolean disableWebPagePreview;

    public InputTextMessageContent(String text, MessageParseMode parseMode, boolean disableWebPagePreview) {
        Preconditions.notEmptyString((String)text, (String)"Text of message should be provided");
        this.text = text.length() > 2096 ? text.substring(0, 4096) : text;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

