/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Location
implements Serializable {
    private static final long serialVersionUID = 1567963952505782270L;
    public final float longitude;
    public final float latitude;

    public Location(float longitude, float latitude) {
        if (Math.abs(longitude) > 180.0f) {
            throw new IllegalArgumentException(String.format("Invalid longitude %f", Float.valueOf(longitude)));
        }
        this.longitude = longitude;
        if (Math.abs(latitude) > 90.0f) {
            throw new IllegalArgumentException(String.format("Invalid latitude %f", Float.valueOf(latitude)));
        }
        this.latitude = latitude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.latitude);
        result = 31 * result + Float.floatToIntBits(this.longitude);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (Float.floatToIntBits(this.latitude) != Float.floatToIntBits(other.latitude)) {
            return false;
        }
        return Float.floatToIntBits(this.longitude) == Float.floatToIntBits(other.longitude);
    }

    public String toString() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }
}

