/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.Command;

public class TelegramUtils {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(JSON_FACTORY);

    public static JsonFactory getJsonFactory() {
        return JSON_FACTORY;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static String parseBotIDFromToken(String token) {
        if (Preconditions.isEmptyString((String)token)) {
            throw new IllegalArgumentException("Cannot parse valid bot ID from null or empty token!");
        }
        return token.split(":", 2)[0];
    }

    public static Command parseCommandFromText(String text) {
        if (Preconditions.isEmptyString((String)text)) {
            return null;
        }
        String[] tmp = text.split(" ", 2);
        String cmdToBot = tmp[0];
        if (Preconditions.isEmptyString((String)cmdToBot)) {
            return null;
        }
        String argument = null;
        if (tmp.length > 1) {
            argument = tmp[1];
        }
        if (Preconditions.isEmptyString((String)(cmdToBot = cmdToBot.replaceFirst("/", "")))) {
            return null;
        }
        tmp = cmdToBot.split("@", 2);
        String type = tmp[0];
        if (Preconditions.isEmptyString((String)type)) {
            return null;
        }
        String toBot = null;
        if (tmp.length > 1) {
            toBot = tmp[1];
        }
        return new Command(type, toBot, argument);
    }
}

