/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.bot;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.bot.TelegramBotSettingsRepository;

public abstract class MySqlBasedTelegramBotSettingsRepository
implements TelegramBotSettingsRepository {
    @Override
    public void saveRobotSettings(String chatOrUserID, String robotID, String propKey, String propValue) {
        if (Preconditions.isEmptyString((String)chatOrUserID) || Preconditions.isEmptyString((String)robotID) || Preconditions.isEmptyString((String)propKey) || Preconditions.isEmptyString((String)propValue)) {
            return;
        }
        String update = "INSERT INTO " + this.getTableName() + "(chat_or_user_id, robot_id, prop_key, prop_value) VALUES(?, ?, ?, ?) ON DUPLICATE KEY UPDATE prop_value = VALUES(prop_value)";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement updatePs = conn.prepareStatement(update);){
            updatePs.setString(1, chatOrUserID);
            updatePs.setString(2, robotID);
            updatePs.setString(3, propKey);
            updatePs.setString(4, propValue);
            updatePs.executeUpdate();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> loadRobotSettings(String chatOrUserID, String robotID) {
        HashMap<String, String> props = new HashMap<String, String>();
        String query = "SELECT prop_key, prop_value FROM " + this.getTableName() + " WHERE chat_or_user_id = ? AND robot_id = ? AND prop_key = ?";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement queryPs = conn.prepareStatement(query);){
            queryPs.setString(1, chatOrUserID);
            queryPs.setString(2, robotID);
            try (ResultSet rs = queryPs.executeQuery();){
                while (rs.next()) {
                    props.put(rs.getString("prop_key"), rs.getString("prop_value"));
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getRobotSettings(String chatOrUserID, String robotID, String propKey) {
        String query = "SELECT prop_value FROM " + this.getTableName() + " WHERE chat_or_user_id = ? AND robot_id = ? AND prop_key = ?";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement queryPs = conn.prepareStatement(query);){
            queryPs.setString(1, chatOrUserID);
            queryPs.setString(2, robotID);
            queryPs.setString(3, propKey);
            try (ResultSet rs = queryPs.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("prop_value");
                return string;
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected abstract DataSource getDataSource();

    protected abstract String getTableName();

    protected abstract Logger getLogger();
}

