/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models.inline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.models.Location;
import org.isuper.telegram.models.User;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChosenInlineResult {
    @JsonProperty(value="result_id")
    public final String resultID;
    @JsonProperty(value="from")
    public final User from;
    @JsonProperty(value="location")
    public final Location location;
    @JsonProperty(value="inline_message_id")
    public final String inlineMessageID;
    @JsonProperty(value="query")
    public final String query;

    @JsonCreator
    public ChosenInlineResult(@JsonProperty(value="result_id") String resultID, @JsonProperty(value="from") User from, @JsonProperty(value="location") Location location, @JsonProperty(value="inline_message_id") String inlineMessageID, @JsonProperty(value="query") String query) {
        this.resultID = resultID;
        Preconditions.notNull((Object)from, (String)"The user that chose the result cannot be null!");
        this.from = from;
        this.location = location;
        this.inlineMessageID = inlineMessageID;
        Preconditions.notNull((Object)query, (String)"The query that was used to obtain the result cannot be null!");
        this.query = query;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

