/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.bot.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.bot.db.UserSettings;

public abstract class MySqlBasedUserSettingsDb
implements UserSettings {
    @Override
    public void saveRobotSettings(long userId, String propKey, String propValue) {
        if (Preconditions.isEmptyString((String)propKey) || Preconditions.isEmptyString((String)propValue)) {
            return;
        }
        String sql = "INSERT INTO " + this.getTableName() + "(user_id, prop_key, prop_value) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE prop_value = VALUES(prop_value)";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, userId);
            ps.setString(2, propKey);
            ps.setString(3, propValue);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> loadRobotSettings(long userId) {
        HashMap<String, String> props = new HashMap<String, String>();
        String sql = "SELECT prop_key, prop_value FROM " + this.getTableName() + " WHERE user_id = ? AND prop_key = ?";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, userId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    props.put(rs.getString("prop_key"), rs.getString("prop_value"));
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getRobotSettings(long userId, String propKey) {
        if (Preconditions.isEmptyString((String)propKey)) {
            return null;
        }
        String sql = "SELECT prop_value FROM " + this.getTableName() + " WHERE user_id = ? AND prop_key = ?";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, userId);
            ps.setString(2, propKey);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("prop_value");
                return string;
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void deleteRobotSettings(long userId) {
        String sql = "DELETE FROM " + this.getTableName() + " WHERE user_id = ?";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, userId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteRobotSettings(long userId, String propKey) {
        if (Preconditions.isEmptyString((String)propKey)) {
            return;
        }
        String sql = "DELETE FROM " + this.getTableName() + " WHERE user_id = ? AND prop_key = ?";
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, userId);
            ps.setString(2, propKey);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract DataSource getDataSource();

    protected abstract String getTableName();

    protected abstract Logger getLogger();
}

