/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.telegram.api;

import org.apache.logging.log4j.Logger;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * @author Super Wayne
 *
 */
public abstract class EndlessRetryableCallback<T> implements Callback<T> {
	
	public EndlessRetryableCallback() {
		
	}

	/* (non-Javadoc)
	 * @see retrofit2.Callback#onFailure(retrofit2.Call, java.lang.Throwable)
	 */
	@Override
	public void onFailure(Call<T> call, Throwable t) {
		call.clone().enqueue(this);
	}

	/* (non-Javadoc)
	 * @see retrofit2.Callback#onResponse(retrofit2.Call, retrofit2.Response)
	 */
	@Override
	public void onResponse(Call<T> call, Response<T> resp) {
		if (resp.isSuccessful()) {
			this.onFinalSuccess(resp.body());
			return;
		}
		if (resp.code() >= 400 && resp.code() < 500) {
			this.onClientError(resp);
			return;
		}
		call.clone().enqueue(this);
	}

	public abstract void onFinalSuccess(T resp);
	public abstract void onClientError(Response<T> resp);
	public abstract Logger getLogger();

}
