/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.telegram.bot;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.isuper.telegram.api.models.Update;

/**
 * @author Super Wayne
 *
 */
public interface BotSessionStore {
	
	void load();

	void save();
	
	boolean hasUpdates();
	
	void addUpdates(List<Update> received);
	
	Update retrieveUpdate(long timeout, TimeUnit unit) throws IOException;

	void setLastReceivedUpdateId(long lastReceivedUpdateId);
	long getLastReceivedUpdateId();

	void setLastUnprocessedUpdate(Update lastUnprocessedUpdate);
	Update getLastUnprocessedUpdate();

}
