/**
 *  Copyright (C) 2014-2017  Super Wayne
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.isuper.telegram.bot.db;

import java.util.Map;

/**
 * @author Super Wayne
 *
 */
public interface UserSettings {

	/**
	 * @param userId
	 * 						The user ID
	 * @param propKey
	 * 						The property key
	 * @return
	 * 						The property value
	 */
	String getRobotSettings(long userId, String propKey);

	/**
	 * @param userId
	 * 						The user ID
	 * @return
	 * 						A hash map of all properties
	 */
	Map<String, String> loadRobotSettings(long userId);

	/**
	 * @param userId
	 * 						The user ID
	 * @param propKey
	 * 						The property key
	 * @param propValue
	 * 						The property value
	 */
	void saveRobotSettings(long userId, String propKey, String propValue);

	/**
	 * @param userId
	 * 						The user ID
	 */
	void deleteRobotSettings(long userId);

	/**
	 * @param userId
	 * 						The user ID
	 * @param propKey
	 * 						The property key
	 */
	void deleteRobotSettings(long userId, String propKey);

}
