/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.telegram.exceptions;

import java.util.List;

import org.apache.http.NameValuePair;
import org.isuper.telegram.api.models.TelegramError;

/**
 * @author Super Wayne
 *
 */
public class NotJsonResponseException extends RecoverableErrorResponseException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5813779808855724381L;

	/**
	 * @param rawContent
	 * 					The raw content of the response.
	 * @param requestFormItems
	 * 					The items sent in the request.
	 */
	public NotJsonResponseException(String rawContent, List<NameValuePair> requestFormItems) {
		super(new TelegramError(false, 500, String.format("Response content not json string: %s", rawContent)), requestFormItems);
	}

}
