/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.inline.InlineQueryResult;
import org.isuper.telegram.utils.TelegramUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnswerInlineQueryPayload {
    private final String queryID;
    private final Collection<InlineQueryResult> results;
    private final Integer cacheTime;
    private final Boolean personal;
    private final String nextOffset;

    public AnswerInlineQueryPayload(String queryID, Collection<InlineQueryResult> results, Integer cacheTime, Boolean personal, String nextOffset) {
        Preconditions.notEmptyString((String)queryID, (String)"Answered query ID should be provided.");
        this.queryID = queryID;
        Preconditions.notNull(results, (String)"Results should be provided.");
        if (results.size() > 50) {
            throw new IllegalArgumentException("No more than 50 results per query are allowed.");
        }
        this.results = results;
        this.cacheTime = cacheTime;
        this.personal = personal;
        this.nextOffset = nextOffset;
    }

    @JsonProperty(value="inline_query_id")
    public String getQueryID() {
        return this.queryID;
    }

    @JsonProperty(value="results")
    public String getResultsStr() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString(this.getResults());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "[]";
        }
    }

    @JsonIgnore
    public Collection<InlineQueryResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="cache_time")
    public Integer getCacheTime() {
        return this.cacheTime;
    }

    @JsonProperty(value="is_personal")
    public Boolean getPersonal() {
        return this.personal;
    }

    @JsonProperty(value="next_offset")
    public String getNextOffset() {
        return this.nextOffset;
    }
}

