/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.markups.ReplyMarkup;
import org.isuper.telegram.utils.TelegramUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EditMessageReplyMarkupPayload {
    private final String chatId;
    private final Long messageId;
    private final String inlineMessageId;
    private final ReplyMarkup replyMarkup;

    public EditMessageReplyMarkupPayload(String chatId, Long messageId, ReplyMarkup replyMarkup) {
        Preconditions.notEmptyString((String)chatId, (String)"Chat ID should be provided");
        this.chatId = chatId;
        Preconditions.notNull((Object)messageId, (String)"Message ID should be provided");
        this.messageId = messageId;
        this.inlineMessageId = null;
        this.replyMarkup = replyMarkup;
    }

    public EditMessageReplyMarkupPayload(String inlineMessageId, ReplyMarkup replyMarkup) {
        this.chatId = null;
        this.messageId = null;
        Preconditions.notNull((Object)inlineMessageId, (String)"Inline message ID should be provided");
        this.inlineMessageId = inlineMessageId;
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="chat_id")
    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="message_id")
    public Long getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="inline_message_id")
    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @JsonProperty(value="reply_markup")
    public String getReplyMarkupJson() throws JsonProcessingException {
        return TelegramUtils.getObjectMapper().writeValueAsString((Object)this.replyMarkup);
    }

    @JsonIgnore
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }
}

