/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.isuper.common.utils.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ForwardMessagePayload {
    private final String chatId;
    private final String fromChatId;
    private final Boolean disableNotification;
    private final long messageId;

    public ForwardMessagePayload(String chatId, String fromChatId, Boolean disableNotification, long messageId) {
        Preconditions.notEmptyString((String)chatId, (String)"Chat ID should be provided");
        this.chatId = chatId;
        Preconditions.notEmptyString((String)fromChatId, (String)"Content of the message should be provided");
        this.fromChatId = fromChatId;
        this.disableNotification = disableNotification;
        this.messageId = messageId;
    }

    @JsonProperty(value="chat_id")
    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="from_chat_id")
    public String getFromChatId() {
        return this.fromChatId;
    }

    @JsonProperty(value="disable_notification")
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @JsonProperty(value="message_id")
    public long getMessageId() {
        return this.messageId;
    }
}

