/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.markups;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineKeyboardButton {
    @JsonProperty(value="text")
    public final String text;
    @JsonProperty(value="url")
    public final String url;
    @JsonProperty(value="callback_data")
    public final String callbackData;
    @JsonProperty(value="switch_inline_query")
    public final String switchInlineQuery;

    public InlineKeyboardButton(@JsonProperty(value="text") String text, @JsonProperty(value="url") String url, @JsonProperty(value="callback_data") String callbackData, @JsonProperty(value="switch_inline_query") String switchInlineQuery) {
        Preconditions.notEmptyString((String)text, (String)"Text should be provided.");
        this.text = text;
        int optionalFieldCnt = 0;
        if (!Preconditions.isEmptyString((String)url)) {
            ++optionalFieldCnt;
        }
        if (!Preconditions.isEmptyString((String)callbackData)) {
            ++optionalFieldCnt;
        }
        if (!Preconditions.isEmptyString((String)switchInlineQuery)) {
            ++optionalFieldCnt;
        }
        if (optionalFieldCnt != 1) {
            throw new IllegalArgumentException("You must use exactly one of the optional fields.");
        }
        this.url = url;
        this.callbackData = callbackData;
        this.switchInlineQuery = switchInlineQuery;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

