/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
implements Serializable {
    private static final long serialVersionUID = 4052116696388288998L;
    public final long id;
    public final String firstName;
    public final String lastName;
    public final String username;

    @JsonCreator
    public User(@JsonProperty(value="id") long id, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="username") String username) {
        this.id = id;
        if (Preconditions.isEmptyString((String)firstName)) {
            throw new IllegalArgumentException("User's or bot's first name cannot be null or empty string!");
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return this.id == other.id;
    }

    public String toString() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }
}

