/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.urlshortener.google;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.isuper.httpclient.AsyncHttpClient;
import org.isuper.urlshortener.google.URLShortenerRequest;
import org.isuper.urlshortener.google.URLShortenerResponse;

public class GoogleURLShortener
implements Closeable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(new JsonFactory());
    private final AsyncHttpClient client;
    private final String endpoint;
    private final String originHost;

    public GoogleURLShortener(String apiKey, String originHost) {
        this(apiKey, originHost, null, 1080);
    }

    public GoogleURLShortener(String apiKey, String originHost, String proxyHostname, int proxyPort) {
        try {
            this.client = AsyncHttpClient.newInstance((String)proxyHostname, (int)proxyPort);
            this.endpoint = String.format("https://www.googleapis.com/urlshortener/v1/url?key=%s", apiKey);
            this.originHost = originHost;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String shortenURL(String longURL) {
        if (longURL == null) {
            return null;
        }
        URLShortenerRequest payload = new URLShortenerRequest(longURL);
        try {
            HttpPost request = new HttpPost(this.endpoint);
            request.setEntity((HttpEntity)new StringEntity(OBJECT_MAPPER.writeValueAsString((Object)payload), ContentType.APPLICATION_JSON));
            if (this.originHost != null) {
                request.addHeader("Origin", this.originHost);
            }
            Future future = this.client.execute((HttpUriRequest)request, null);
            HttpResponse resp = (HttpResponse)future.get();
            StatusLine status = resp.getStatusLine();
            HttpEntity entity = resp.getEntity();
            String contentType = entity.getContentType().getValue();
            if (status.getStatusCode() != 200) {
                throw new IOException(String.format("%d response received from server", status.getStatusCode()));
            }
            String content = EntityUtils.toString((HttpEntity)entity);
            if (contentType.indexOf("application/json") >= 0) {
                URLShortenerResponse shortenerResp = (URLShortenerResponse)OBJECT_MAPPER.readValue(content, URLShortenerResponse.class);
                return shortenerResp.id;
            }
            throw new IOException(String.format("Expecting a json response, but actually got a %s reponse with content: %s", contentType, content));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

