/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.urlshortener.google;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.urlshortener.google.URLShortenerRequest;
import org.isuper.urlshortener.google.URLShortenerResponse;

public class GoogleURLShortener
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"google-url-shortener");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(new JsonFactory());
    private final CloseableHttpAsyncClient httpclient;
    private final String endpoint;
    private final String originHost;

    public GoogleURLShortener(String apiKey, String originHost) {
        RequestConfig reqConf = RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        this.httpclient = HttpAsyncClients.custom().useSystemProperties().setDefaultCookieStore((CookieStore)new BasicCookieStore()).setDefaultRequestConfig(reqConf).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
        this.httpclient.start();
        this.endpoint = String.format("https://www.googleapis.com/urlshortener/v1/url?key=%s", apiKey);
        this.originHost = originHost;
    }

    public String shortenURL(String longURL) {
        if (longURL == null) {
            return null;
        }
        URLShortenerRequest payload = new URLShortenerRequest(longURL);
        try {
            HttpPost request = new HttpPost(this.endpoint);
            request.setEntity((HttpEntity)new StringEntity(OBJECT_MAPPER.writeValueAsString((Object)payload), ContentType.APPLICATION_JSON));
            if (this.originHost != null) {
                request.addHeader("Origin", this.originHost);
            }
            HttpResponse resp = (HttpResponse)this.httpclient.execute((HttpUriRequest)request, null).get();
            StatusLine status = resp.getStatusLine();
            HttpEntity entity = resp.getEntity();
            String contentType = entity.getContentType().getValue();
            if (status.getStatusCode() != 200) {
                LOGGER.error(String.format("%d response received from server", status.getStatusCode()));
                return null;
            }
            String content = EntityUtils.toString((HttpEntity)entity);
            if (contentType.indexOf("application/json") >= 0) {
                URLShortenerResponse shortenerResp = (URLShortenerResponse)OBJECT_MAPPER.readValue(content, URLShortenerResponse.class);
                return shortenerResp.id;
            }
            LOGGER.error(String.format("Expecting a json response, but actually got a %s reponse with content: %s", contentType, content));
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpclient.close();
    }
}

