/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.urlshortener.google;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Super Wayne
 *
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class URLShortenerResponse implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7280012214319756375L;
	
	public final String kind;
	public final String id;
	public final String longUrl;
	
	/**
	 * @param kind
	 * 				The type of response
	 * @param id
	 * 				The short URL
	 * @param longUrl
	 * 				The original long URL
	 */
	public URLShortenerResponse(@JsonProperty("kind") String kind, @JsonProperty("id") String id, @JsonProperty("longUrl") String longUrl) {
		super();
		this.kind = kind;
		this.id = id;
		this.longUrl = longUrl;
	}

}
