/*
 * Decompiled with CFR 0.152.
 */
package org.itechet.resteasy.demo01.resources;

import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.itechet.resteasy.demo01.services.CartService;

@Path(value="/cart")
public class Cart {
    @Inject
    CartService cartService;

    @POST
    @Produces(value={"application/json", "application/xml"})
    public void addItem(@QueryParam(value="itemId") String itemId, @Suspended AsyncResponse response) {
        this.cartService.add(itemId);
        response.resume((Object)Response.ok().build());
    }

    @DELETE
    @Produces(value={"application/json", "application/xml"})
    public void deleteItem(@QueryParam(value="itemId") String itemId, @Suspended AsyncResponse response) {
        this.cartService.delete(itemId);
        response.resume((Object)Response.noContent().build());
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public void getItem(@Suspended AsyncResponse response) {
        response.resume((Object)this.cartService.getContent());
    }
}

