/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.dao.dynamodb.EnhancerHelper;
import org.iternine.jeppetto.dao.persistable.PersistableList;
import org.iternine.jeppetto.dao.persistable.PersistableMap;
import org.iternine.jeppetto.enhance.Enhancer;

public class ConversionUtil {
    private static final Set<Class> STORE_AS_NUMBER_CLASSES = new HashSet<Class>(){
        {
            this.add(Date.class);
            this.add(Byte.TYPE);
            this.add(Short.TYPE);
            this.add(Integer.TYPE);
            this.add(Long.TYPE);
            this.add(Float.TYPE);
            this.add(Double.TYPE);
            this.add(Number.class);
            this.add(BigDecimal.class);
            this.add(BigInteger.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
        }
    };

    public static Map<String, AttributeValue> getItemFromObject(DynamoDBPersistable dynamoDBPersistable) {
        HashMap<String, AttributeValue> itemMap = new HashMap<String, AttributeValue>();
        Iterator dirtyFields = dynamoDBPersistable.__getDirtyFields();
        while (dirtyFields.hasNext()) {
            String dirtyField = (String)dirtyFields.next();
            Object object = dynamoDBPersistable.__get(dirtyField);
            if (object == null) continue;
            itemMap.put(dirtyField, ConversionUtil.toAttributeValue(object));
        }
        return itemMap;
    }

    public static <T> AttributeValue toAttributeValue(T value) {
        return ConversionUtil.toAttributeValue(value, null);
    }

    public static <T> AttributeValue toAttributeValue(T value, Class collectionType) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue((String)value);
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue().withN(value.toString());
        }
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue().withBOOL((Boolean)value);
        }
        if (Character.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue(value.toString());
        }
        if (Byte.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue().withN(value.toString());
        }
        if (byte[].class.isAssignableFrom(value.getClass())) {
            return new AttributeValue().withB(ByteBuffer.wrap((byte[])value));
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue().withN(Long.toString(((Date)value).getTime()));
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue(((Enum)value).name());
        }
        if (Set.class.isAssignableFrom(value.getClass())) {
            Set valueSet = (Set)value;
            HashSet<String> strings = new HashSet<String>(valueSet.size());
            for (Object next : valueSet) {
                strings.add(ConversionUtil.toString(next));
            }
            if (collectionType != null && STORE_AS_NUMBER_CLASSES.contains(collectionType)) {
                return new AttributeValue().withNS(strings);
            }
            return new AttributeValue().withSS(strings);
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List valueList = (List)value;
            ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>(valueList.size());
            for (Object next : valueList) {
                attributeValues.add(ConversionUtil.toAttributeValue(next));
            }
            return new AttributeValue().withL(attributeValues);
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            Map valueMap = (Map)value;
            HashMap attributeValueMap = new HashMap(valueMap.size());
            for (Map.Entry entry : valueMap.entrySet()) {
                attributeValueMap.put(entry.getKey(), ConversionUtil.toAttributeValue(entry.getValue()));
            }
            return new AttributeValue().withM(attributeValueMap);
        }
        if (AttributeValue.class.isAssignableFrom(value.getClass())) {
            return (AttributeValue)value;
        }
        Enhancer<?> enhancer = EnhancerHelper.getPersistableEnhancer(value.getClass());
        DynamoDBPersistable dynamoDBPersistable = (DynamoDBPersistable)enhancer.enhance(value);
        return new AttributeValue().withM(ConversionUtil.getItemFromObject(dynamoDBPersistable));
    }

    public static <T> T getObjectFromItem(Map<String, AttributeValue> item, Class<T> targetType) {
        Object t = EnhancerHelper.getPersistableEnhancer(targetType).newInstance();
        ((DynamoDBPersistable)t).__putAll(item);
        return (T)t;
    }

    public static Object fromAttributeValue(AttributeValue attributeValue, Class targetType, Class collectionType) {
        if (String.class.isAssignableFrom(targetType)) {
            return attributeValue.getS();
        }
        if (Integer.class.isAssignableFrom(targetType) || Integer.TYPE.isAssignableFrom(targetType)) {
            return Integer.valueOf(attributeValue.getN());
        }
        if (Long.class.isAssignableFrom(targetType) || Long.TYPE.isAssignableFrom(targetType)) {
            return Long.valueOf(attributeValue.getN());
        }
        if (Double.class.isAssignableFrom(targetType) || Double.TYPE.isAssignableFrom(targetType)) {
            return Double.valueOf(attributeValue.getN());
        }
        if (Float.class.isAssignableFrom(targetType) || Float.TYPE.isAssignableFrom(targetType)) {
            return Float.valueOf(attributeValue.getN());
        }
        if (Boolean.class.isAssignableFrom(targetType) || Boolean.TYPE.isAssignableFrom(targetType)) {
            return attributeValue.getBOOL();
        }
        if (Character.class.isAssignableFrom(targetType) || Character.TYPE.isAssignableFrom(targetType)) {
            return Character.valueOf(attributeValue.getS().charAt(0));
        }
        if (Byte.class.isAssignableFrom(targetType) || Byte.TYPE.isAssignableFrom(targetType)) {
            return Byte.valueOf(attributeValue.getN());
        }
        if (Short.class.isAssignableFrom(targetType) || Short.TYPE.isAssignableFrom(targetType)) {
            return Short.valueOf(attributeValue.getN());
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return new Date(Long.parseLong(attributeValue.getN()));
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            return Enum.valueOf(targetType, attributeValue.getS());
        }
        if (Set.class.isAssignableFrom(targetType)) {
            HashSet<Object> result = new HashSet<Object>();
            List strings = attributeValue.getSS() != null ? attributeValue.getSS() : attributeValue.getNS();
            for (String string : strings) {
                result.add(ConversionUtil.fromString(string, collectionType));
            }
            return result;
        }
        if (List.class.isAssignableFrom(targetType)) {
            List attributeValues = attributeValue.getL();
            PersistableList result = new PersistableList(attributeValues.size());
            for (AttributeValue value : attributeValues) {
                result.add(ConversionUtil.fromAttributeValue(value, collectionType, null));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(targetType)) {
            Map attributeValues = attributeValue.getM();
            PersistableMap result = new PersistableMap(attributeValues.size());
            for (Map.Entry entry : attributeValues.entrySet()) {
                result.put(entry.getKey(), ConversionUtil.fromAttributeValue((AttributeValue)entry.getValue(), collectionType, null));
            }
            return result;
        }
        return ConversionUtil.getObjectFromItem(attributeValue.getM(), targetType);
    }

    public static Collection<AttributeValue> toAttributeValueList(Object value) {
        ArrayList<AttributeValue> attributeValueList = new ArrayList<AttributeValue>();
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                attributeValueList.add(ConversionUtil.toAttributeValue(Array.get(value, i)));
            }
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            for (Object item : (Collection)value) {
                attributeValueList.add(ConversionUtil.toAttributeValue(item));
            }
        } else {
            throw new JeppettoException("Expected either array or Collection object.");
        }
        return attributeValueList;
    }

    private static String toString(Object value) {
        if (Date.class.isAssignableFrom(value.getClass())) {
            return Long.toString(((Date)value).getTime());
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        return value.toString();
    }

    private static Object fromString(String string, Class type) {
        if (type == null || String.class.isAssignableFrom(type)) {
            return string;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Integer.valueOf(string);
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Long.valueOf(string);
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Double.valueOf(string);
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(string);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Boolean.valueOf(string);
        }
        if (Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) {
            return Character.valueOf(string.charAt(0));
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return Byte.valueOf(string);
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return Short.valueOf(string);
        }
        if (Date.class.isAssignableFrom(type)) {
            return new Date(Long.parseLong(string));
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum.valueOf(type, string);
        }
        throw new RuntimeException("Unhandled type: " + type);
    }
}

