/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import org.iternine.jeppetto.dao.dynamodb.ConversionUtil;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBOperator;

public class DynamoDBConstraint {
    private DynamoDBOperator operator;
    private Object[] values;

    public DynamoDBConstraint(DynamoDBOperator operator, Object ... values) {
        this.operator = operator;
        this.values = values;
    }

    public Condition asCondition() {
        Condition condition = new Condition().withComparisonOperator(this.operator.getComparisonOperator());
        int argumentCount = this.operator.getArgumentCount();
        if (argumentCount == 1) {
            condition.withAttributeValueList(new AttributeValue[]{ConversionUtil.toAttributeValue(this.values[0])});
        } else if (argumentCount == 2) {
            condition.withAttributeValueList(new AttributeValue[]{ConversionUtil.toAttributeValue(this.values[0]), ConversionUtil.toAttributeValue(this.values[1])});
        } else if (argumentCount != 0) {
            condition.setAttributeValueList(ConversionUtil.toAttributeValueList(this.values[0]));
        }
        return condition;
    }

    public DynamoDBOperator getOperator() {
        return this.operator;
    }

    public Object[] getValues() {
        return this.values;
    }
}

