/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb;

import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import java.util.Iterator;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBConstraint;

public enum DynamoDBOperator {
    NotEqual(ComparisonOperator.NE, 1),
    GreaterThanEqual(ComparisonOperator.GE, 1),
    LessThanEqual(ComparisonOperator.LE, 1),
    Equal(ComparisonOperator.EQ, 1),
    GreaterThan(ComparisonOperator.GT, 1),
    LessThan(ComparisonOperator.LT, 1),
    NotWithin(null, -1),
    Within(ComparisonOperator.IN, -1),
    Between(ComparisonOperator.BETWEEN, 2),
    IsNull(ComparisonOperator.NOT_NULL, 0),
    IsNotNull(ComparisonOperator.NULL, 0);

    private ComparisonOperator comparisonOperator;
    private int argumentCount;

    private DynamoDBOperator(ComparisonOperator comparisonOperator, int argumentCount) {
        this.comparisonOperator = comparisonOperator;
        this.argumentCount = argumentCount;
    }

    public DynamoDBConstraint buildConstraint(Iterator argsIterator) {
        switch (this.argumentCount) {
            case 0: {
                return new DynamoDBConstraint(this, new Object[0]);
            }
            case 2: {
                return new DynamoDBConstraint(this, argsIterator.next(), argsIterator.next());
            }
        }
        return new DynamoDBConstraint(this, argsIterator.next());
    }

    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }
}

