/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.expression;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.dynamodb.ConversionUtil;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.dao.dynamodb.expression.ExpressionBuilder;
import org.iternine.jeppetto.dao.persistable.PersistableList;
import org.iternine.jeppetto.dao.updateobject.NumericIncrement;
import org.iternine.jeppetto.dao.updateobject.UpdateList;
import org.iternine.jeppetto.dao.updateobject.UpdateMap;
import org.iternine.jeppetto.dao.updateobject.UpdateObject;

public class UpdateExpressionBuilder
extends ExpressionBuilder {
    private static final String EXPRESSION_ATTRIBUTE_VALUE_PREFIX = ":u";
    private static final String EXPRESSION_ATTRIBUTE_NAME_PREFIX = "#u";
    private final StringBuilder setExpression = new StringBuilder();
    private final StringBuilder removeExpression = new StringBuilder();

    public UpdateExpressionBuilder(DynamoDBPersistable dynamoDBPersistable) {
        super(true);
        this.extractUpdateDetails(dynamoDBPersistable, "");
    }

    public UpdateExpressionBuilder(UpdateObject updateObject) {
        super(true);
        this.extractUpdateDetails(updateObject, "");
    }

    @Override
    public boolean hasExpression() {
        return this.setExpression.length() > 0 || this.removeExpression.length() > 0;
    }

    @Override
    public String getExpression() {
        StringBuilder expression = new StringBuilder();
        if (this.setExpression.length() > 0) {
            expression.append("SET ");
            expression.append((CharSequence)this.setExpression);
        }
        if (this.removeExpression.length() > 0) {
            if (expression.length() > 0) {
                expression.append(' ');
            }
            expression.append("REMOVE ");
            expression.append((CharSequence)this.removeExpression);
        }
        return expression.toString();
    }

    @Override
    public String getExpressionAttributeValuePrefix() {
        return EXPRESSION_ATTRIBUTE_VALUE_PREFIX;
    }

    @Override
    public String getExpressionAttributeNamePrefix() {
        return EXPRESSION_ATTRIBUTE_NAME_PREFIX;
    }

    private void extractUpdateDetails(DynamoDBPersistable dynamoDBPersistable, String prefix) {
        Iterator dirtyFieldsIterator = dynamoDBPersistable.__getDirtyFields();
        while (dirtyFieldsIterator.hasNext()) {
            String field = (String)dirtyFieldsIterator.next();
            Object object = dynamoDBPersistable.__get(field);
            String fullyQualifiedField = prefix + this.getExpressionAttributeName(field);
            if (object == null) {
                this.append(this.removeExpression, fullyQualifiedField);
                continue;
            }
            if (PersistableList.class.isAssignableFrom(object.getClass())) {
                throw new JeppettoException("Not yet implemented");
            }
            if (DynamoDBPersistable.class.isAssignableFrom(object.getClass())) {
                this.extractUpdateDetails((DynamoDBPersistable)object, fullyQualifiedField + ".");
                continue;
            }
            this.addToSetExpression(object, fullyQualifiedField);
        }
    }

    private void extractUpdateDetails(UpdateObject updateObject, String prefix) {
        for (Map.Entry updateEntry : updateObject.__getUpdates().entrySet()) {
            String fullyQualifiedField = prefix + this.getExpressionAttributeName((String)updateEntry.getKey());
            Object object = updateEntry.getValue();
            if (object == null) {
                this.append(this.removeExpression, fullyQualifiedField);
                continue;
            }
            if (UpdateList.class.isAssignableFrom(object.getClass())) {
                UpdateList updateList = (UpdateList)object;
                if (updateList.wasCleared()) {
                    this.addToSetExpression(updateList.getAdds(), fullyQualifiedField);
                    continue;
                }
                this.extractUpdateDetails((UpdateObject)updateList, fullyQualifiedField);
                if (updateList.getAdds().isEmpty()) continue;
                this.addListItemsToSetExpression(updateList.getAdds(), fullyQualifiedField);
                continue;
            }
            if (UpdateMap.class.isAssignableFrom(object.getClass())) {
                UpdateMap updateMap = (UpdateMap)object;
                if (updateMap.wasCleared()) {
                    this.addToSetExpression(updateMap, fullyQualifiedField);
                    continue;
                }
                this.extractUpdateDetails((UpdateObject)updateMap, fullyQualifiedField + ".");
                continue;
            }
            if (NumericIncrement.class.isAssignableFrom(object.getClass())) {
                this.addIncrementToSetExpression(((NumericIncrement)object).getIncrement(), fullyQualifiedField);
                continue;
            }
            if (UpdateObject.class.isAssignableFrom(object.getClass())) {
                this.extractUpdateDetails((UpdateObject)object, fullyQualifiedField + ".");
                continue;
            }
            this.addToSetExpression(object, fullyQualifiedField);
        }
    }

    private void addToSetExpression(Object object, String fullyQualifiedField) {
        String expressionAttributeValueKey = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(object));
        this.append(this.setExpression, fullyQualifiedField + " = " + expressionAttributeValueKey);
    }

    private void addListItemsToSetExpression(List<Object> adds, String fullyQualifiedField) {
        String expressionAttributeValueKey = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(adds));
        this.append(this.setExpression, fullyQualifiedField + " = list_append(" + fullyQualifiedField + ", " + expressionAttributeValueKey + ')');
    }

    private void addIncrementToSetExpression(Number number, String fullyQualifiedField) {
        String incrementString;
        String numberString = number.toString();
        if (numberString.charAt(0) == '-') {
            String expressionAttributeValueKey = this.putExpressionAttributeValue(new AttributeValue().withN(numberString.substring(1)));
            incrementString = " - " + expressionAttributeValueKey;
        } else {
            String expressionAttributeValueKey = this.putExpressionAttributeValue(new AttributeValue().withN(numberString));
            incrementString = " + " + expressionAttributeValueKey;
        }
        this.append(this.setExpression, fullyQualifiedField + " = " + fullyQualifiedField + incrementString);
    }

    private void append(StringBuilder sb, String text) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(text);
    }
}

