/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.iterable;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.enhance.Enhancer;

public abstract class DynamoDBIterable<T>
implements Iterable<T> {
    private AmazonDynamoDB dynamoDB;
    private Enhancer<T> enhancer;
    private String hashKeyField;
    private Iterator<Map<String, AttributeValue>> iterator;
    private Map<String, AttributeValue> lastItem;

    public DynamoDBIterable(AmazonDynamoDB dynamoDB, Enhancer<T> enhancer, String hashKeyField) {
        this.dynamoDB = dynamoDB;
        this.enhancer = enhancer;
        this.hashKeyField = hashKeyField;
    }

    protected abstract Map<String, AttributeValue> getLastEvaluatedKey();

    protected abstract void setExclusiveStartKey(Map<String, AttributeValue> var1);

    protected abstract Iterator<Map<String, AttributeValue>> fetchItems();

    protected abstract boolean moreAvailable();

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            {
                DynamoDBIterable.this.iterator = DynamoDBIterable.this.fetchItems();
            }

            @Override
            public boolean hasNext() {
                if (DynamoDBIterable.this.iterator.hasNext()) {
                    return true;
                }
                if (DynamoDBIterable.this.moreAvailable()) {
                    DynamoDBIterable.this.iterator = DynamoDBIterable.this.fetchItems();
                }
                return DynamoDBIterable.this.iterator.hasNext();
            }

            @Override
            public T next() {
                DynamoDBIterable.this.lastItem = (Map)DynamoDBIterable.this.iterator.next();
                Object t = DynamoDBIterable.this.enhancer.newInstance();
                ((DynamoDBPersistable)t).__putAll(DynamoDBIterable.this.lastItem);
                ((DynamoDBPersistable)t).__markPersisted(DynamoDBIterable.this.dynamoDB.toString());
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getPosition() {
        return this.getPosition(false);
    }

    public String getPosition(boolean removeHashKey) {
        Map<String, AttributeValue> lastExaminedKey = this.getLastExaminedKey();
        if (lastExaminedKey == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, AttributeValue> entry : lastExaminedKey.entrySet()) {
                if (removeHashKey && entry.getKey().equals(this.hashKeyField)) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey()).append('=').append(this.encode(entry.getValue()));
            }
            return URLEncoder.encode(Base64.encodeAsString((byte[])sb.toString().getBytes()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPosition(String position) {
        this.setPosition(position, null);
    }

    public void setPosition(String position, String hashKeyValue) {
        if (this.iterator != null) {
            throw new JeppettoException("setPosition() only valid on a new DynamoDBIterable.");
        }
        if (position == null) {
            return;
        }
        try {
            byte[] decodedBytes = Base64.decode((String)URLDecoder.decode(position, StandardCharsets.UTF_8.name()));
            String[] attributePairs = new String(decodedBytes).split("&");
            if (attributePairs.length == 0) {
                return;
            }
            HashMap<String, AttributeValue> exclusiveStartKey = new HashMap<String, AttributeValue>();
            for (String attributePair : attributePairs) {
                String[] parts = attributePair.split("=");
                if (parts.length != 2) {
                    throw new JeppettoException("Corrupted position: " + position + "; found attribute: " + attributePair);
                }
                exclusiveStartKey.put(parts[0], this.decode(parts[1]));
            }
            if (hashKeyValue != null) {
                exclusiveStartKey.put(this.hashKeyField, new AttributeValue(hashKeyValue));
            }
            this.setExclusiveStartKey(exclusiveStartKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected AmazonDynamoDB getDynamoDB() {
        return this.dynamoDB;
    }

    protected Enhancer<T> getEnhancer() {
        return this.enhancer;
    }

    private Map<String, AttributeValue> getLastExaminedKey() {
        Map<String, AttributeValue> lastEvaluatedKey = this.getLastEvaluatedKey();
        if (lastEvaluatedKey == null) {
            return null;
        }
        HashMap<String, AttributeValue> generatedKey = new HashMap<String, AttributeValue>(lastEvaluatedKey.size());
        for (String key : lastEvaluatedKey.keySet()) {
            generatedKey.put(key, this.lastItem.get(key));
        }
        return generatedKey;
    }

    private String encode(AttributeValue attributeValue) throws UnsupportedEncodingException {
        String intermediate;
        if (attributeValue.getS() != null) {
            intermediate = "S" + attributeValue.getS();
        } else if (attributeValue.getN() != null) {
            intermediate = "N" + attributeValue.getN();
        } else {
            throw new JeppettoException("Can only handle 'S' and 'N' scalar types: " + attributeValue);
        }
        return URLEncoder.encode(intermediate, StandardCharsets.UTF_8.name());
    }

    private AttributeValue decode(String encoded) throws UnsupportedEncodingException {
        if (encoded.startsWith("S")) {
            return new AttributeValue().withS(URLDecoder.decode(encoded.substring(1), StandardCharsets.UTF_8.name()));
        }
        if (encoded.startsWith("N")) {
            return new AttributeValue().withN(URLDecoder.decode(encoded.substring(1), StandardCharsets.UTF_8.name()));
        }
        throw new JeppettoException("Can only handle 'S' and 'N' scalar types: " + encoded);
    }
}

