/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.FailedBatchException;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.OptimisticLockException;
import org.iternine.jeppetto.dao.Pair;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.QueryModel;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.ResultFromUpdate;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.UpdateBehaviorDescriptor;
import org.iternine.jeppetto.dao.dynamodb.ConversionUtil;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBConstraint;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBOperator;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.dao.dynamodb.EnhancerHelper;
import org.iternine.jeppetto.dao.dynamodb.expression.ConditionExpressionBuilder;
import org.iternine.jeppetto.dao.dynamodb.expression.ProjectionExpressionBuilder;
import org.iternine.jeppetto.dao.dynamodb.expression.UpdateExpressionBuilder;
import org.iternine.jeppetto.dao.dynamodb.iterable.BatchGetIterable;
import org.iternine.jeppetto.dao.dynamodb.iterable.DynamoDBIterable;
import org.iternine.jeppetto.dao.dynamodb.iterable.QueryIterable;
import org.iternine.jeppetto.dao.dynamodb.iterable.ScanIterable;
import org.iternine.jeppetto.dao.id.IdGenerator;
import org.iternine.jeppetto.dao.updateobject.UpdateObject;
import org.iternine.jeppetto.enhance.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBQueryModelDAO<T, ID>
implements QueryModelDAO<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBQueryModelDAO.class);
    private final Class<T> entityClass;
    private final AmazonDynamoDB dynamoDB;
    private final String tableName;
    private final IdGenerator<ID> idGenerator;
    private final boolean consistentRead;
    private final String optimisticLockField;
    private final boolean enableScans;
    private final String hashKeyField;
    private final String rangeKeyField;
    private final String projectionExpression;
    private final Map<String, String> projectionExpressionNames;
    private final Map<String, Map<String, IndexData>> indexes;
    private final Map<String, Map<String, IndexData>> baseIndexOnly;
    private final Enhancer<T> persistableEnhancer;
    private final Enhancer<? extends T> updateObjectEnhancer;
    private final String uniqueIdConditionExpression;

    protected DynamoDBQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties) {
        this(entityClass, daoProperties, null);
    }

    protected DynamoDBQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        ProjectionExpressionBuilder projectionExpressionBuilder;
        this.entityClass = entityClass;
        this.dynamoDB = (AmazonDynamoDB)daoProperties.get("db");
        this.tableName = daoProperties.containsKey("tableName") ? (String)daoProperties.get("tableName") : entityClass.getSimpleName();
        this.idGenerator = (IdGenerator)daoProperties.get("idGenerator");
        this.consistentRead = Boolean.parseBoolean((String)daoProperties.get("consistentRead"));
        this.optimisticLockField = (String)daoProperties.get("optimisticLockField");
        this.enableScans = Boolean.parseBoolean((String)daoProperties.get("enableScans"));
        TableDescription tableDescription = this.dynamoDB.describeTable(this.tableName).getTable();
        Pair<String, String> primaryKeyAttributeNames = this.getKeyAttributeNames(tableDescription.getKeySchema());
        this.hashKeyField = (String)primaryKeyAttributeNames.getFirst();
        this.rangeKeyField = (String)primaryKeyAttributeNames.getSecond();
        if (Boolean.parseBoolean((String)daoProperties.get("projectionObject"))) {
            projectionExpressionBuilder = new ProjectionExpressionBuilder(entityClass, this.hashKeyField, this.rangeKeyField, this.optimisticLockField);
            this.projectionExpression = projectionExpressionBuilder.getExpression();
            this.projectionExpressionNames = projectionExpressionBuilder.getExpressionAttributeNames();
        } else {
            projectionExpressionBuilder = null;
            this.projectionExpression = null;
            this.projectionExpressionNames = Collections.emptyMap();
        }
        List<String> keyFields = this.rangeKeyField == null ? Collections.singletonList(this.hashKeyField) : Arrays.asList(this.hashKeyField, this.rangeKeyField);
        IndexData baseIndexData = new IndexData(null, keyFields, true);
        this.baseIndexOnly = Collections.singletonMap(this.hashKeyField, Collections.singletonMap(this.rangeKeyField, baseIndexData));
        this.indexes = this.processIndexes(tableDescription, projectionExpressionBuilder, baseIndexData);
        this.persistableEnhancer = EnhancerHelper.getPersistableEnhancer(entityClass);
        String updateObjectClassName = (String)daoProperties.get("updateObject");
        if (updateObjectClassName == null) {
            this.updateObjectEnhancer = EnhancerHelper.getUpdateObjectEnhancer(entityClass);
        } else {
            try {
                Class<?> updateObjectClass = Class.forName(updateObjectClassName);
                if (!entityClass.isAssignableFrom(updateObjectClass)) {
                    throw new JeppettoException(String.format("Invalid UpdateObject type. %s does not subclass entity type %s", updateObjectClassName, entityClass.getName()));
                }
                this.updateObjectEnhancer = EnhancerHelper.getUpdateObjectEnhancer(updateObjectClass);
            }
            catch (ClassNotFoundException e) {
                throw new JeppettoException((Throwable)e);
            }
        }
        if (Boolean.parseBoolean((String)daoProperties.get("verifyUniqueIds"))) {
            ConditionExpressionBuilder conditionExpressionBuilder = new ConditionExpressionBuilder().with(this.hashKeyField, new DynamoDBConstraint(DynamoDBOperator.IsNull, new Object[0]));
            if (this.rangeKeyField != null) {
                conditionExpressionBuilder.with(this.rangeKeyField, new DynamoDBConstraint(DynamoDBOperator.IsNull, new Object[0]));
            }
            this.uniqueIdConditionExpression = conditionExpressionBuilder.getExpression();
        } else {
            this.uniqueIdConditionExpression = null;
        }
    }

    public T findById(ID id) throws NoSuchItemException, JeppettoException {
        GetItemResult result;
        try {
            GetItemRequest getItemRequest = new GetItemRequest(this.tableName, this.getKeyFrom(id), Boolean.valueOf(this.consistentRead));
            getItemRequest.setProjectionExpression(this.projectionExpression);
            if (!this.projectionExpressionNames.isEmpty()) {
                getItemRequest.setExpressionAttributeNames(this.projectionExpressionNames);
            }
            result = this.dynamoDB.getItem(getItemRequest);
        }
        catch (AmazonClientException e) {
            throw new JeppettoException((Throwable)e);
        }
        if (result.getItem() == null) {
            throw new NoSuchItemException(this.entityClass.getSimpleName(), id.toString());
        }
        T t = ConversionUtil.getObjectFromItem(result.getItem(), this.entityClass);
        ((DynamoDBPersistable)t).__markPersisted(this.dynamoDB.toString());
        return t;
    }

    @SafeVarargs
    public final Iterable<T> findByIds(ID ... ids) throws JeppettoException {
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>();
        for (ID id : ids) {
            keys.add(this.getKeyFrom(id));
        }
        KeysAndAttributes keysAndAttributes = new KeysAndAttributes().withKeys(keys);
        keysAndAttributes.setConsistentRead(Boolean.valueOf(this.consistentRead));
        keysAndAttributes.setProjectionExpression(this.projectionExpression);
        if (!this.projectionExpressionNames.isEmpty()) {
            keysAndAttributes.setExpressionAttributeNames(this.projectionExpressionNames);
        }
        BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest().withRequestItems(Collections.singletonMap(this.tableName, keysAndAttributes));
        return new BatchGetIterable<T>(this.dynamoDB, this.persistableEnhancer, batchGetItemRequest, this.tableName);
    }

    public Iterable<T> findAll() throws JeppettoException {
        return this.findUsingQueryModel(new QueryModel());
    }

    public void save(T entity) throws OptimisticLockException, JeppettoException {
        DynamoDBPersistable dynamoDBPersistable = (DynamoDBPersistable)this.persistableEnhancer.enhance(entity);
        if (!dynamoDBPersistable.__isPersisted(this.dynamoDB.toString())) {
            if (this.optimisticLockField != null) {
                dynamoDBPersistable.__put(this.optimisticLockField, new AttributeValue().withN("0"));
            }
            this.saveItem(dynamoDBPersistable);
        } else {
            ConditionExpressionBuilder conditionExpressionBuilder;
            if (this.optimisticLockField != null) {
                int optimisticLockVersion;
                AttributeValue attributeValue = (AttributeValue)dynamoDBPersistable.__get(this.optimisticLockField);
                if (attributeValue != null) {
                    optimisticLockVersion = Integer.parseInt(attributeValue.getN());
                    conditionExpressionBuilder = new ConditionExpressionBuilder();
                    conditionExpressionBuilder.with(this.optimisticLockField, new DynamoDBConstraint(DynamoDBOperator.Equal, optimisticLockVersion));
                } else {
                    optimisticLockVersion = -1;
                    conditionExpressionBuilder = null;
                }
                dynamoDBPersistable.__put(this.optimisticLockField, new AttributeValue().withN(Integer.toString(optimisticLockVersion + 1)));
            } else {
                conditionExpressionBuilder = null;
            }
            try {
                UpdateExpressionBuilder updateExpressionBuilder = new UpdateExpressionBuilder(dynamoDBPersistable);
                this.updateItem(this.getKeyFrom(dynamoDBPersistable), updateExpressionBuilder, conditionExpressionBuilder, ResultFromUpdate.ReturnNone);
            }
            catch (JeppettoException e) {
                if (this.optimisticLockField != null && e.getCause() instanceof ConditionalCheckFailedException) {
                    throw new OptimisticLockException(e.getCause());
                }
                throw e;
            }
        }
        dynamoDBPersistable.__markPersisted(this.dynamoDB.toString());
    }

    public void delete(T entity) throws JeppettoException {
        if (entity == null) {
            throw new JeppettoException("entity is null; nothing to delete.");
        }
        this.deleteItem(this.getKeyFrom((DynamoDBPersistable)this.persistableEnhancer.enhance(entity)));
    }

    public void deleteById(ID id) throws JeppettoException {
        if (id == null) {
            throw new JeppettoException("id is null; unable to delete entity.");
        }
        this.deleteItem(this.getKeyFrom(id));
    }

    @SafeVarargs
    public final void deleteByIds(ID ... ids) throws FailedBatchException, JeppettoException {
        ArrayList<ID> succeeded = new ArrayList<ID>();
        LinkedHashMap<ID, Exception> failed = new LinkedHashMap<ID, Exception>();
        for (ID id : ids) {
            try {
                this.deleteItem(this.getKeyFrom(id));
                succeeded.add(id);
            }
            catch (Exception e) {
                failed.put(id, e);
            }
        }
        if (failed.size() > 0) {
            throw new FailedBatchException("Unable to delete all items", succeeded, failed);
        }
    }

    public <U extends T> U getUpdateObject() {
        return (U)this.updateObjectEnhancer.newInstance();
    }

    public <U extends T> T updateById(U updateObject, ID id) throws JeppettoException {
        return this.updateItem(this.getKeyFrom(id), new UpdateExpressionBuilder((UpdateObject)updateObject), null, this.getResultFromUpdate(updateObject));
    }

    @SafeVarargs
    public final <U extends T> Iterable<T> updateByIds(U updateObject, ID ... ids) throws FailedBatchException, JeppettoException {
        LinkedHashMap<ID, Exception> failed = new LinkedHashMap<ID, Exception>();
        ResultFromUpdate resultFromUpdate = this.getResultFromUpdate(updateObject);
        ArrayList<Object> succeeded = resultFromUpdate == ResultFromUpdate.ReturnNone ? new ArrayList<Object>() : new ArrayList();
        UpdateExpressionBuilder updateExpressionBuilder = new UpdateExpressionBuilder((UpdateObject)updateObject);
        for (ID id : ids) {
            try {
                T t = this.updateItem(this.getKeyFrom(id), updateExpressionBuilder, null, resultFromUpdate);
                if (resultFromUpdate == ResultFromUpdate.ReturnNone) {
                    succeeded.add(id);
                    continue;
                }
                succeeded.add(t);
            }
            catch (Exception e) {
                failed.put(id, e);
            }
        }
        if (failed.size() > 0) {
            throw new FailedBatchException("Unable to update all items", succeeded, failed);
        }
        return resultFromUpdate == ResultFromUpdate.ReturnNone ? null : succeeded;
    }

    public void flush() throws JeppettoException {
    }

    public T findUniqueUsingQueryModel(QueryModel queryModel) throws NoSuchItemException, TooManyItemsException, JeppettoException {
        DynamoDBIterable dynamoDBIterable = (DynamoDBIterable)this.findUsingQueryModel(queryModel);
        dynamoDBIterable.setLimit(1);
        Iterator results = dynamoDBIterable.iterator();
        if (!results.hasNext()) {
            throw new NoSuchItemException();
        }
        Object result = results.next();
        if (dynamoDBIterable.hasResultsPastLimit()) {
            throw new TooManyItemsException();
        }
        return result;
    }

    public Iterable<T> findUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        ConditionExpressionBuilder conditionExpressionBuilder = new ConditionExpressionBuilder(queryModel, this.indexes);
        if (conditionExpressionBuilder.hasHashKeyCondition()) {
            return this.queryItems(queryModel, conditionExpressionBuilder);
        }
        if (this.enableScans) {
            logger.info("Condition does not specify a hash key -- using 'scan' to search.");
            conditionExpressionBuilder.convertRangeKeyConditionToExpression();
            return this.scanItems(queryModel, conditionExpressionBuilder);
        }
        throw new JeppettoException("Find cannot be satisfied without a scan and scans have not been enabled.  Configure this DAO with 'enableScans' = true to allow this.");
    }

    public Object projectUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        throw new UnsupportedOperationException("Projections on DynamoDB are not currently supported.");
    }

    public void deleteUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        Iterable<T> matches = this.findUsingQueryModel(queryModel);
        for (T match : matches) {
            this.delete(match);
        }
    }

    public <U extends T> T updateUniqueUsingQueryModel(U updateObject, QueryModel queryModel) throws JeppettoException {
        Map<String, AttributeValue> key;
        UpdateExpressionBuilder updateExpressionBuilder = new UpdateExpressionBuilder((UpdateObject)updateObject);
        ConditionExpressionBuilder conditionExpressionBuilder = new ConditionExpressionBuilder(queryModel, this.baseIndexOnly);
        ResultFromUpdate resultFromUpdate = this.getResultFromUpdate(updateObject);
        try {
            key = conditionExpressionBuilder.getKey();
        }
        catch (NullPointerException e) {
            throw new JeppettoException("DynamoDB only supports updates where the condition uniquely identifies the item by its key.", (Throwable)e);
        }
        return this.updateItem(key, updateExpressionBuilder, conditionExpressionBuilder, resultFromUpdate);
    }

    public <U extends T> Iterable<T> updateUsingQueryModel(U updateObject, QueryModel queryModel) throws JeppettoException {
        T t = this.updateUniqueUsingQueryModel(updateObject, queryModel);
        if (t == null) {
            return null;
        }
        return Collections.singletonList(t);
    }

    public Condition buildCondition(String conditionField, ConditionType conditionType, Iterator argsIterator) {
        return new Condition(conditionField, (Object)DynamoDBOperator.valueOf(conditionType.name()).buildConstraint(argsIterator));
    }

    public Projection buildProjection(String projectionField, ProjectionType projectionType, Iterator argsIterator) {
        throw new UnsupportedOperationException("Projections on DynamoDB are not currently supported.");
    }

    private Map<String, Map<String, IndexData>> processIndexes(TableDescription tableDescription, ProjectionExpressionBuilder projectionExpressionBuilder, IndexData baseIndexData) {
        Map<Object, IndexData> localIndexes;
        List localSecondaryIndexes = tableDescription.getLocalSecondaryIndexes();
        if (localSecondaryIndexes != null) {
            localIndexes = new HashMap<Object, IndexData>(localSecondaryIndexes.size() + 2);
            localIndexes.put(this.rangeKeyField, baseIndexData);
            localIndexes.put(null, baseIndexData);
            for (LocalSecondaryIndexDescription description : localSecondaryIndexes) {
                String indexField = (String)this.getKeyAttributeNames(description.getKeySchema()).getSecond();
                boolean projectsOverEntity = description.getProjection().getProjectionType().equals("ALL") || projectionExpressionBuilder != null && projectionExpressionBuilder.isCoveredBy(description.getProjection()) != false;
                ArrayList<String> keyFields = new ArrayList<String>(baseIndexData.keyFields);
                keyFields.add(indexField);
                localIndexes.put(indexField, new IndexData(description.getIndexName(), keyFields, projectsOverEntity));
            }
        } else if (this.rangeKeyField != null) {
            localIndexes = new HashMap<Object, IndexData>(2);
            localIndexes.put(this.rangeKeyField, baseIndexData);
            localIndexes.put(null, baseIndexData);
        } else {
            localIndexes = Collections.singletonMap(null, baseIndexData);
        }
        List globalSecondaryIndexes = tableDescription.getGlobalSecondaryIndexes();
        if (globalSecondaryIndexes != null) {
            HashMap<String, Map<String, IndexData>> indexes = new HashMap<String, Map<String, IndexData>>(globalSecondaryIndexes.size() + 1);
            for (GlobalSecondaryIndexDescription description : globalSecondaryIndexes) {
                Pair<String, String> indexFields = this.getKeyAttributeNames(description.getKeySchema());
                boolean projectsOverEntity = description.getProjection().getProjectionType().equals("ALL") || projectionExpressionBuilder != null && projectionExpressionBuilder.isCoveredBy(description.getProjection()) != false;
                ArrayList<Object> keyFields = new ArrayList<Object>();
                keyFields.add(indexFields.getFirst());
                if (indexFields.getSecond() != null) {
                    keyFields.add(indexFields.getSecond());
                }
                keyFields.add(this.hashKeyField);
                if (this.rangeKeyField != null) {
                    keyFields.add(this.rangeKeyField);
                }
                IndexData indexData = new IndexData(description.getIndexName(), keyFields, projectsOverEntity);
                if (!indexes.containsKey(indexFields.getFirst())) {
                    indexes.put((String)indexFields.getFirst(), new HashMap());
                }
                ((Map)indexes.get(indexFields.getFirst())).put(indexFields.getSecond(), indexData);
                IndexData noRangeKeyIndexData = (IndexData)((Map)indexes.get(indexFields.getFirst())).get(null);
                if (noRangeKeyIndexData != null && noRangeKeyIndexData.projectsOverEntity) continue;
                ((Map)indexes.get(indexFields.getFirst())).put(null, indexData);
            }
            indexes.put(this.hashKeyField, localIndexes);
            return indexes;
        }
        return Collections.singletonMap(this.hashKeyField, localIndexes);
    }

    private void saveItem(DynamoDBPersistable dynamoDBPersistable) {
        this.generateIdIfNeeded(dynamoDBPersistable);
        try {
            PutItemRequest putItemRequest = new PutItemRequest().withTableName(this.tableName).withItem(ConversionUtil.getItemFromObject(dynamoDBPersistable)).withConditionExpression(this.uniqueIdConditionExpression);
            this.dynamoDB.putItem(putItemRequest);
        }
        catch (Exception e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    private T updateItem(Map<String, AttributeValue> key, UpdateExpressionBuilder updateExpressionBuilder, ConditionExpressionBuilder conditionExpressionBuilder, ResultFromUpdate resultFromUpdate) {
        try {
            Map<String, String> expressionAttributeNames;
            Map<String, AttributeValue> expressionAttributeValues;
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(this.tableName).withKey(key).withUpdateExpression(updateExpressionBuilder.getExpression());
            if (conditionExpressionBuilder == null) {
                expressionAttributeValues = updateExpressionBuilder.getExpressionAttributeValues();
                expressionAttributeNames = updateExpressionBuilder.getExpressionAttributeNames();
            } else {
                expressionAttributeValues = new LinkedHashMap<String, AttributeValue>();
                expressionAttributeNames = new LinkedHashMap<String, String>();
                expressionAttributeValues.putAll(updateExpressionBuilder.getExpressionAttributeValues());
                expressionAttributeNames.putAll(updateExpressionBuilder.getExpressionAttributeNames());
                expressionAttributeValues.putAll(conditionExpressionBuilder.getExpressionAttributeValues());
                expressionAttributeNames.putAll(conditionExpressionBuilder.getExpressionAttributeNames());
                updateItemRequest.setConditionExpression(conditionExpressionBuilder.getExpression());
            }
            if (!expressionAttributeValues.isEmpty()) {
                updateItemRequest.setExpressionAttributeValues(expressionAttributeValues);
            }
            if (!expressionAttributeNames.isEmpty()) {
                updateItemRequest.setExpressionAttributeNames(expressionAttributeNames);
            }
            if (resultFromUpdate != ResultFromUpdate.ReturnNone) {
                updateItemRequest.setReturnValues(resultFromUpdate == ResultFromUpdate.ReturnPreUpdate ? ReturnValue.ALL_OLD : ReturnValue.ALL_NEW);
                UpdateItemResult result = this.dynamoDB.updateItem(updateItemRequest);
                T t = ConversionUtil.getObjectFromItem(result.getAttributes(), this.entityClass);
                ((DynamoDBPersistable)t).__markPersisted(this.dynamoDB.toString());
                return t;
            }
            this.dynamoDB.updateItem(updateItemRequest);
            return null;
        }
        catch (Exception e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    private void deleteItem(Map<String, AttributeValue> key) {
        try {
            this.dynamoDB.deleteItem(new DeleteItemRequest(this.tableName, key));
        }
        catch (Exception e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    private Iterable<T> queryItems(QueryModel queryModel, ConditionExpressionBuilder conditionExpressionBuilder) {
        QueryRequest queryRequest = new QueryRequest(this.tableName);
        queryRequest.setKeyConditions(conditionExpressionBuilder.getKeyConditions());
        queryRequest.setConsistentRead(Boolean.valueOf(this.consistentRead));
        if (queryModel.getFirstResult() > 0) {
            logger.warn("DynamoDB does not support skipping results.  Call setPosition() on DynamoDBIterable instead.");
        }
        if (queryModel.getMaxResults() > 0) {
            queryRequest.setLimit(Integer.valueOf(queryModel.getMaxResults()));
        }
        List<String> keyFields = this.applyIndexAndGetKeyFields(conditionExpressionBuilder, queryRequest, queryModel.getSorts());
        this.applyExpressions(conditionExpressionBuilder, queryRequest);
        return new QueryIterable<T>(this.dynamoDB, this.persistableEnhancer, queryRequest, keyFields.get(0), keyFields);
    }

    private List<String> applyIndexAndGetKeyFields(ConditionExpressionBuilder conditionExpressionBuilder, QueryRequest queryRequest, List<Sort> sorts) {
        IndexData indexData;
        String hashKey = conditionExpressionBuilder.getHashKey();
        String rangeKey = conditionExpressionBuilder.getRangeKey();
        if (sorts == null || sorts.isEmpty()) {
            indexData = this.indexes.get(hashKey).get(rangeKey);
        } else if (sorts.size() == 1) {
            Sort sort = sorts.get(0);
            String sortKey = sort.getField();
            if (rangeKey != null && !rangeKey.equals(sortKey)) {
                throw new JeppettoException("DynamoDB can only sort on the effective range key. Unable to sort on: " + sortKey);
            }
            queryRequest.setScanIndexForward(Boolean.valueOf(sort.getSortDirection() == SortDirection.Ascending));
            indexData = this.indexes.get(hashKey).get(sortKey);
        } else {
            throw new JeppettoException("DynamoDB only supports one sort value.");
        }
        if (indexData.indexName != null && !indexData.projectsOverEntity) {
            logger.warn("Query using index {} incurs additional costs to fully fetch a {} type. Use a projected object DAO to avoid this overhead.", (Object)indexData.indexName, (Object)this.entityClass.getSimpleName());
        }
        queryRequest.setIndexName(indexData.indexName);
        return indexData.keyFields;
    }

    private void applyExpressions(ConditionExpressionBuilder conditionExpressionBuilder, QueryRequest queryRequest) {
        Map<String, String> expressionAttributeNames;
        queryRequest.setProjectionExpression(this.projectionExpression);
        if (conditionExpressionBuilder.hasExpression()) {
            queryRequest.setFilterExpression(conditionExpressionBuilder.getExpression());
            if (!conditionExpressionBuilder.getExpressionAttributeValues().isEmpty()) {
                queryRequest.setExpressionAttributeValues(conditionExpressionBuilder.getExpressionAttributeValues());
            }
            expressionAttributeNames = this.getExpressionAttributeNames(conditionExpressionBuilder);
        } else {
            expressionAttributeNames = this.projectionExpressionNames;
        }
        if (!expressionAttributeNames.isEmpty()) {
            queryRequest.setExpressionAttributeNames(expressionAttributeNames);
        }
    }

    private Iterable<T> scanItems(QueryModel queryModel, ConditionExpressionBuilder conditionExpressionBuilder) {
        Map<String, String> expressionAttributeNames;
        ScanRequest scanRequest = new ScanRequest(this.tableName);
        if (queryModel.getFirstResult() > 0) {
            logger.warn("DynamoDB does not support skipping results.  Call setPosition() on DynamoDBIterable instead.");
        }
        if (queryModel.getMaxResults() > 0) {
            scanRequest.setLimit(Integer.valueOf(queryModel.getMaxResults()));
        }
        if (queryModel.getSorts() != null) {
            logger.warn("Not able to sort when performing a 'scan' operation.  Ignoring... ");
        }
        scanRequest.setProjectionExpression(this.projectionExpression);
        if (conditionExpressionBuilder.hasExpression()) {
            scanRequest.setFilterExpression(conditionExpressionBuilder.getExpression());
            if (!conditionExpressionBuilder.getExpressionAttributeValues().isEmpty()) {
                scanRequest.setExpressionAttributeValues(conditionExpressionBuilder.getExpressionAttributeValues());
            }
            expressionAttributeNames = this.getExpressionAttributeNames(conditionExpressionBuilder);
        } else {
            expressionAttributeNames = this.projectionExpressionNames;
        }
        if (!expressionAttributeNames.isEmpty()) {
            scanRequest.setExpressionAttributeNames(expressionAttributeNames);
        }
        return new ScanIterable<T>(this.dynamoDB, this.persistableEnhancer, scanRequest, this.rangeKeyField == null ? Collections.singleton(this.hashKeyField) : Arrays.asList(this.hashKeyField, this.rangeKeyField));
    }

    private Map<String, String> getExpressionAttributeNames(ConditionExpressionBuilder conditionExpressionBuilder) {
        Map<String, String> expressionAttributeNames;
        if (this.projectionExpressionNames.isEmpty()) {
            expressionAttributeNames = conditionExpressionBuilder.getExpressionAttributeNames();
        } else if (conditionExpressionBuilder.getExpressionAttributeNames().isEmpty()) {
            expressionAttributeNames = this.projectionExpressionNames;
        } else {
            expressionAttributeNames = new LinkedHashMap<String, String>();
            expressionAttributeNames.putAll(conditionExpressionBuilder.getExpressionAttributeNames());
            expressionAttributeNames.putAll(this.projectionExpressionNames);
        }
        return expressionAttributeNames;
    }

    private <U extends T> ResultFromUpdate getResultFromUpdate(U updateObject) {
        if (UpdateBehaviorDescriptor.class.isAssignableFrom(updateObject.getClass())) {
            ResultFromUpdate resultFromUpdate = ((UpdateBehaviorDescriptor)updateObject).getResultFromUpdate();
            return resultFromUpdate != null ? resultFromUpdate : ResultFromUpdate.ReturnNone;
        }
        return ResultFromUpdate.ReturnNone;
    }

    private void generateIdIfNeeded(DynamoDBPersistable dynamoDBPersistable) {
        if (dynamoDBPersistable.__get(this.hashKeyField) != null) {
            return;
        }
        if (this.idGenerator == null) {
            throw new JeppettoException("No id provided, and no id generator available.");
        }
        dynamoDBPersistable.__putAll(this.getKeyFrom(this.idGenerator.generateId()));
    }

    private AttributeValue getAttributeValue(Object value) {
        if (Number.class.isAssignableFrom(value.getClass())) {
            return new AttributeValue().withN(value.toString());
        }
        return new AttributeValue(value.toString());
    }

    private Pair<String, String> getKeyAttributeNames(List<KeySchemaElement> keySchema) {
        Pair keyAttributes = new Pair();
        for (KeySchemaElement keySchemaElement : keySchema) {
            if (keySchemaElement.getKeyType().equals(KeyType.HASH.name())) {
                keyAttributes.setFirst((Object)keySchemaElement.getAttributeName());
                continue;
            }
            keyAttributes.setSecond((Object)keySchemaElement.getAttributeName());
        }
        return keyAttributes;
    }

    private Map<String, AttributeValue> getKeyFrom(ID id) {
        HashMap<String, AttributeValue> key;
        if (Pair.class.isAssignableFrom(id.getClass())) {
            key = new HashMap<String, AttributeValue>(2);
            key.put(this.hashKeyField, this.getAttributeValue(((Pair)id).getFirst()));
            key.put(this.rangeKeyField, this.getAttributeValue(((Pair)id).getSecond()));
        } else {
            key = Collections.singletonMap(this.hashKeyField, this.getAttributeValue(id));
        }
        return key;
    }

    private Map<String, AttributeValue> getKeyFrom(DynamoDBPersistable dynamoDBPersistable) {
        HashMap<String, AttributeValue> key;
        if (this.rangeKeyField != null) {
            key = new HashMap<String, AttributeValue>(2);
            key.put(this.hashKeyField, ConversionUtil.toAttributeValue(dynamoDBPersistable.__get(this.hashKeyField)));
            key.put(this.rangeKeyField, ConversionUtil.toAttributeValue(dynamoDBPersistable.__get(this.rangeKeyField)));
        } else {
            key = Collections.singletonMap(this.hashKeyField, ConversionUtil.toAttributeValue(dynamoDBPersistable.__get(this.hashKeyField)));
        }
        return key;
    }

    public static class IndexData {
        String indexName;
        List<String> keyFields;
        boolean projectsOverEntity;

        private IndexData(String indexName, List<String> keyFields, boolean projectsOverEntity) {
            this.indexName = indexName;
            this.keyFields = keyFields;
            this.projectsOverEntity = projectsOverEntity;
        }
    }
}

